/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.rotation;

import com.mojang.blaze3d.vertex.PoseStack;
import kasuga.lib.core.client.animation.neo_neo.VectorUtil;
import kasuga.lib.core.client.animation.neo_neo.base.Movement;
import kasuga.lib.core.client.animation.neo_neo.point.PivotPoint;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public abstract class Rotation
extends Movement {
    private boolean degree;
    private PivotPoint pivot;

    public Rotation(Vec3 data, float startTime, float endTime, boolean degree) {
        super(data, startTime, endTime);
        this.degree = degree;
        this.pivot = new PivotPoint();
    }

    public boolean isDegree() {
        return this.degree;
    }

    public void setDegree(boolean degree) {
        if (degree == this.degree) {
            return;
        }
        this.data = VectorUtil.translateDegAndRad(this.data, degree);
        this.degree = degree;
    }

    public void rot(Vec3 vec3) {
        this.data = VectorUtil.rot(this.data, vec3, this.isDegree());
    }

    public PivotPoint getPivot() {
        return this.pivot;
    }

    public void offsetPivot(double x, double y, double z) {
        this.pivot.translate(x, y, z);
    }

    public void offsetPivot(Vec3 offset) {
        this.pivot.translate(offset);
    }

    public void absOffsetPivot(double x, double y, double z) {
        this.pivot.absTranslate(x, y, z);
    }

    public void absOffsetPivot(Vec3 offset) {
        this.pivot.absTranslate(offset);
    }

    public void rotPivot(Vec3 rot, boolean degree) {
        this.pivot.rotate(rot, degree);
    }

    public void resetPivot() {
        this.pivot.setPosition(Vec3.f_82478_);
        this.pivot.setRotation(Vec3.f_82478_);
    }

    public void setPivot(PivotPoint pivot) {
        this.pivot = pivot;
    }

    @Override
    public abstract Vec3 getPercentage(float var1);

    @Override
    public void move(float time, PoseStack pose) {
        this.pivot.apply(pose);
        pose.m_85845_(VectorUtil.getQuaternion(this.getPercentage(this.calculateTime(time)), this.degree));
        this.pivot.reverseApply(pose);
    }

    @Override
    public void apply(PivotPoint point, float time) {
        point.rotate(this.getPercentage(this.calculateTime(time)), this.isDegree());
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        nbt.m_128379_("degree", this.isDegree());
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.degree = nbt.m_128471_("degree");
    }
}

