/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.translation;

import java.util.LinkedList;
import java.util.List;
import kasuga.lib.core.client.animation.neo_neo.InterpolationUtil;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.animation.neo_neo.base.IBezier;
import kasuga.lib.core.client.animation.neo_neo.translation.Translation;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public class BezierTranslation
extends Translation
implements IBezier {
    private final List<Vec3> bezierPoints;
    Pair<Float, Vec3> cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);

    public BezierTranslation(Vec3 data, float startTime, float endTime) {
        super(data, startTime, endTime);
        this.bezierPoints = new LinkedList<Vec3>();
    }

    public BezierTranslation(Vec3 data, float startTime, float endTime, List<Vec3> bezierPoints) {
        this(data, startTime, endTime);
        this.bezierPoints.addAll(bezierPoints);
    }

    @Override
    public void reset() {
        this.bezierPoints.clear();
        this.cache = Pair.of(Float.valueOf(0.0f), Vec3.f_82478_);
        super.reset();
    }

    @Override
    public Vec3 getPercentage(float percentage) {
        if (this.cache.getFirst().equals(Float.valueOf(percentage))) {
            return this.cache.getSecond();
        }
        Vec3 result = InterpolationUtil.bezier(Vec3.f_82478_, this.data, this.bezierPoints, percentage);
        this.cache = Pair.of(Float.valueOf(percentage), result);
        return result;
    }

    @Override
    public List<Vec3> getBezierPoints() {
        return this.bezierPoints;
    }

    @Override
    public Vec3 getMovementVector() {
        return this.getData();
    }

    @Override
    public void createDefaultBezier(IBezier before) {
        InterpolationUtil.createDefaultBezier(before, this, 0.33333334f);
    }

    @Override
    public void write(CompoundTag nbt) {
        super.write(nbt);
        VectorIOUtil.writeVec3ListToNbt(nbt, "bezier", this.bezierPoints);
    }

    @Override
    public void read(CompoundTag nbt) {
        super.read(nbt);
        this.bezierPoints.clear();
        this.bezierPoints.addAll(VectorIOUtil.getVec3ListFromNbt(nbt, "bezier"));
    }
}

