/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.common.style;

import java.util.function.Consumer;
import java.util.function.Function;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaNode;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;

public interface StyleTarget {
    public static final StyleTargetType<YogaNode> LAYOUT_NODE = new StyleTargetType<YogaNode>(n -> n instanceof YogaNode, n -> (YogaNode)n);
    public static final StyleTargetType<GuiDomNode> GUI_DOM_NODE = new StyleTargetType<GuiDomNode>(n -> n instanceof GuiDomNode, n -> (GuiDomNode)n);

    public boolean canApplyTo(Object var1);

    public void apply(Object var1);

    default public void attemptApply(Object object) {
        if (this.canApplyTo(object)) {
            this.apply(object);
        }
    }

    public static class StyleTargetType<T> {
        protected final Function<Object, Boolean> filter;
        protected final Function<Object, T> transformer;

        public StyleTargetType(Function<Object, Boolean> filter, Function<Object, T> transformer) {
            this.filter = filter;
            this.transformer = transformer;
        }

        public StyleTarget create(final Consumer<T> consumer) {
            return new StyleTarget(){

                @Override
                public boolean canApplyTo(Object object) {
                    return filter.apply(object);
                }

                @Override
                public void apply(Object object) {
                    consumer.accept(transformer.apply(object));
                }
            };
        }
    }
}

