/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom;

import com.caoccao.javet.annotations.V8Convert;
import java.util.ArrayDeque;
import kasuga.lib.core.client.frontend.dom.event.EventEmitter;
import kasuga.lib.core.client.frontend.dom.nodes.DomNode;
import kasuga.lib.core.client.frontend.dom.registration.DOMPriorityRegistry;
import kasuga.lib.core.client.frontend.dom.registration.DOMRegistryItemDynamicProxy;
import kasuga.lib.core.javascript.Tickable;
import kasuga.lib.core.javascript.engine.HostAccess;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.util.Callback;
import net.minecraft.resources.ResourceLocation;

@V8Convert
public abstract class DomContext<P extends DomNode<?>, T extends P>
implements Tickable {
    protected boolean ready = false;
    T rootNode;
    DOMRegistryItemDynamicProxy renderer;
    protected ArrayDeque<Callback> queue = new ArrayDeque();
    EventEmitter emitter = new EventEmitter();

    public void appendTask(Callback callback) {
        this.queue.add(callback);
    }

    protected DomContext(DOMPriorityRegistry registry, ResourceLocation location) {
        this.rootNode = this.createRoot();
        this.renderer = new DOMRegistryItemDynamicProxy(registry, location, this);
    }

    protected abstract T createRoot();

    public abstract P createNodeInternal(String var1);

    @HostAccess.Export
    public T getRootNode() {
        return this.rootNode;
    }

    @HostAccess.Export
    public P createNode(String name) {
        return this.createNodeInternal(name);
    }

    public void start() {
        this.renderer.load();
        this.renderer.enable();
    }

    public void stop() {
        this.renderer.disable();
        this.renderer.unload();
    }

    public DOMRegistryItemDynamicProxy getRenderer() {
        return this.renderer;
    }

    @Override
    public void tick() {
        int taskNumebr = 0;
        while (!this.queue.isEmpty() && ++taskNumebr < 64) {
            this.queue.poll().execute();
        }
    }

    public void setReady() {
        this.ready = true;
    }

    public void setNotReady() {
        this.ready = false;
    }

    @HostAccess.Export
    public void addEventListener(String eventName, JavascriptValue callback) {
        this.emitter.subscribe(eventName, callback);
    }

    @HostAccess.Export
    public void removeEventListener(String eventName, JavascriptValue callback) {
        this.emitter.unsubscribe(eventName, callback);
    }

    @HostAccess.Export
    public void dispatchEvent(String eventName, Object event) {
        this.emitter.dispatchEvent(eventName, event);
    }
}

