/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom.attribute;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.client.frontend.dom.attribute.AttributeProxy;
import kasuga.lib.core.util.Callback;

public class AttributeMap {
    Map<String, AttributeProxy> specialAttributes = new HashMap<String, AttributeProxy>();
    Map<String, Set<Callback>> callbacks = new HashMap<String, Set<Callback>>();
    Map<String, String> attributes = new HashMap<String, String>();

    public void registerCallback(String attributeName, Callback callback) {
        this.callbacks.computeIfAbsent(attributeName, s -> new HashSet()).add(callback);
    }

    public void removeCallback(String attributeName, Callback callback) {
        if (!this.callbacks.containsKey(attributeName)) {
            return;
        }
        Set<Callback> attributeCallbacks = this.callbacks.get(attributeName);
        attributeCallbacks.remove(callback);
        if (attributeCallbacks.isEmpty()) {
            this.callbacks.remove(attributeName);
        }
    }

    public void setValue(String attributeName, String attributeValue) {
        if (attributeValue == null) {
            this.attributes.remove(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
        }
        if (this.callbacks.containsKey(attributeName)) {
            for (Callback callback : this.callbacks.get(attributeName)) {
                callback.execute();
            }
        }
    }

    public void set(String attributeName, String attributeValue) {
        if (this.specialAttributes.containsKey(attributeName)) {
            this.setValue(attributeName, this.specialAttributes.get(attributeName).set(attributeValue));
            return;
        }
        this.setValue(attributeName, attributeValue);
    }

    public String get(String attributeName) {
        if (this.specialAttributes.containsKey(attributeName)) {
            return this.specialAttributes.get(attributeName).get();
        }
        return this.attributes.get(attributeName);
    }

    public String get(String attributeName, String defaultValue) {
        return this.attributes.getOrDefault(attributeName, defaultValue);
    }

    public void registerProxy(String attribute, AttributeProxy proxy) {
        this.specialAttributes.put(attribute, proxy);
    }
}

