/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiAttachTarget
implements Iterable<Object> {
    Set<Entity> entity = new HashSet<Entity>();
    Set<BlockEntity> block = new HashSet<BlockEntity>();
    Set<Screen> screen = new HashSet<Screen>();
    Set<Object> objects = new HashSet<Object>();
    int unattachedLivingTicks = 0;

    public void detach() {
        this.entity.clear();
        this.block.clear();
        this.screen.clear();
    }

    public boolean isClosable() {
        return this.isBlockEntitySourceClosable() && this.isEntitySourceClosable() && this.isScreenSourceClosable() && this.objects.isEmpty();
    }

    public boolean isBlockEntitySourceClosable() {
        return this.block.stream().allMatch(block -> !block.m_58898_() || block.m_58901_() || !block.m_58904_().m_46749_(block.m_58899_()));
    }

    public boolean isEntitySourceClosable() {
        return this.entity.stream().allMatch(e -> e.m_213877_() || !e.m_9236_().m_46749_(e.m_20183_()));
    }

    public boolean isScreenSourceClosable() {
        Minecraft minecraft = Minecraft.m_91087_();
        return this.screen.isEmpty();
    }

    public int tickClosable() {
        if (this.isClosable()) {
            return this.unattachedLivingTicks++;
        }
        this.unattachedLivingTicks = 0;
        return 0;
    }

    public void attach(BlockEntity block) {
        this.block.add(block);
    }

    public void attach(Screen screen) {
        this.screen.add(screen);
    }

    public void attach(Entity entity) {
        this.entity.add(entity);
    }

    public void detach(BlockEntity block) {
        this.block.remove(block);
    }

    public void detach(Screen screen) {
        this.screen.remove(null);
    }

    public void detach(Entity entity) {
        this.entity.remove(entity);
    }

    public void attach(Object object) {
        this.objects.add(object);
    }

    public void detach(Object object) {
        this.objects.remove(object);
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.entity);
        list.addAll(this.block);
        list.addAll(this.screen);
        return list.iterator();
    }
}

