/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui;

import com.caoccao.javet.annotations.V8Convert;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.layouting.LayoutEngine;
import kasuga.lib.core.client.frontend.dom.DomContext;
import kasuga.lib.core.client.frontend.dom.registration.DOMPriorityRegistry;
import kasuga.lib.core.client.frontend.gui.GuiAttachTarget;
import kasuga.lib.core.client.frontend.gui.SourceInfo;
import kasuga.lib.core.client.frontend.gui.layout.LayoutEngines;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomRoot;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.Tickable;
import net.minecraft.resources.ResourceLocation;

@V8Convert
public class GuiContext
extends DomContext<GuiDomNode, GuiDomRoot>
implements Tickable {
    LayoutEngine<?, GuiDomNode> layoutEngine;
    GuiAttachTarget attachedTargets = new GuiAttachTarget();
    ReentrantLock renderLock = new ReentrantLock();
    public volatile boolean isRendering;
    HashMap<Object, SourceInfo> info = new HashMap();

    public GuiContext(DOMPriorityRegistry registry, ResourceLocation location) {
        super(registry, location);
        this.layoutEngine = LayoutEngines.YOGA;
    }

    @Override
    protected GuiDomRoot createRoot() {
        return new GuiDomRoot(this);
    }

    @Override
    public GuiDomNode createNodeInternal(String name) {
        return KasugaLib.STACKS.GUI.orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).nodeTypeRegistry.create(name, this);
    }

    public GuiAttachTarget getAttachedTargets() {
        return this.attachedTargets;
    }

    public void createSource(Object source) {
        ((GuiDomRoot)this.getRootNode()).getLayoutManager().addSource(source);
    }

    public void removeSource(Object source) {
        ((GuiDomRoot)this.getRootNode()).getLayoutManager().removeSource(source);
    }

    public LayoutEngine<?, GuiDomNode> getLayoutEngine() {
        return this.layoutEngine;
    }

    public SourceInfo getSourceInfo(Object source) {
        return this.info.get(source);
    }

    public void setSourceInfo(Object source, SourceInfo sourceInfo) {
        this.info.put(source, sourceInfo);
    }

    public void removeSourceInfo(Object source) {
        this.info.remove(source);
    }

    @Override
    public void tick() {
        super.tick();
        ((GuiDomRoot)this.getRootNode()).getLayoutManager().tick();
    }

    public void renderTick() {
    }

    public void render(Object source, RenderContext context) {
        if (!this.ready) {
            return;
        }
        ((GuiDomRoot)this.getRootNode()).render(source, context);
    }

    public void queueDuringRender(Runnable task) {
        Optional<JavascriptContext> threadContext = this.getRenderer().getContext();
        if (threadContext.isEmpty()) {
            task.run();
            return;
        }
        JavascriptContext context = threadContext.get();
        if (!this.isRendering) {
            this.renderLock.lock();
            context.beforeRenderTick();
            RuntimeException _e = null;
            try {
                task.run();
            }
            catch (RuntimeException e) {
                _e = e;
            }
            this.renderLock.unlock();
            if (_e != null) {
                throw _e;
            }
        } else {
            context.enqueueAfterRenderTask(task);
        }
    }

    public void queueDuringRenderUnsafe(Runnable task) {
        Optional<JavascriptContext> threadContext = this.getRenderer().getContext();
        if (threadContext.isEmpty()) {
            task.run();
            return;
        }
        JavascriptContext context = threadContext.get();
        if (!this.isRendering) {
            context.beforeRenderTick();
            task.run();
            this.renderLock.unlock();
        } else {
            context.enqueueAfterRenderTask(task);
        }
    }
}

