/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.nodes;

import java.util.Map;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.canvas.CanvasRenderingContext2D;
import kasuga.lib.core.client.frontend.gui.canvas.glfw.CanvasRenderer;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.javascript.engine.HostAccess;

public class GuiCanvasNode
extends GuiDomNode {
    CanvasRenderer renderer;
    private Map<String, Object> contextCache;

    GuiCanvasNode(GuiContext context) {
        super(context);
    }

    @Override
    public void render(Object source, RenderContext context) {
        if (!this.getLayoutManager().hasSource(source)) {
            return;
        }
        LayoutNode layout = this.getLayoutManager().getSourceNode(source);
        LayoutBox positionBox = layout.getPosition();
        String realWidthStr = this.attributes.get("width");
        String realHeightStr = this.attributes.get("height");
        int realWidth = -1;
        int realHeight = -1;
        try {
            realWidth = Integer.parseInt(realWidthStr);
            realHeight = Integer.parseInt(realHeightStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (realHeight <= 0) {
            realHeight = (int)Math.floor(positionBox.getHeight());
        }
        if (realWidth <= 0) {
            realWidth = (int)Math.floor(positionBox.getHeight());
        }
        if (this.renderer == null) {
            this.renderer = KasugaLib.STACKS.GUI.orElseThrow().canvasManager.create(realHeight, realWidth);
        }
        super.render(source, context);
        this.renderer.renderToScreen(positionBox.x, positionBox.y, positionBox.width, positionBox.height);
    }

    @Override
    public void close() {
        super.close();
    }

    @HostAccess.Export
    public Object getContext(String contextType) {
        switch (contextType) {
            case "2d": {
                return this.contextCache.computeIfAbsent("2d", i -> new CanvasRenderingContext2D(this.renderer));
            }
        }
        throw new IllegalArgumentException("Unsupported Canvas Context Type:");
    }
}

