/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.nodes;

import com.caoccao.javet.annotations.V8Convert;
import java.util.Optional;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutContext;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.dom.attribute.AttributeProxy;
import kasuga.lib.core.client.frontend.font.FontHelper;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.layout.yoga.MayMeasurable;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureFunction;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureMode;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureOutput;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.core.client.render.font.Font;
import kasuga.lib.core.client.render.font.PivotPosition;
import kasuga.lib.core.client.render.font.TextContext;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec2;

@V8Convert
public class GuiTextNode
extends GuiDomNode
implements MayMeasurable {
    static Font font = new Font();
    TextContext context;
    String content = "";
    String color = "";
    LazyRecomputable<Pair<Integer, Integer>> measureResult = LazyRecomputable.of(() -> {
        Vec2 measureResult = FontHelper.measure(Minecraft.m_91087_().f_91062_, (Integer)this.fontSize.get(), this.content, 1.0f);
        return Pair.of((int)measureResult.f_82470_, (int)measureResult.f_82471_);
    });

    GuiTextNode(GuiContext context) {
        super(context);
        this.attributes.registerProxy("content", new AttributeProxy(){

            @Override
            public String get() {
                return GuiTextNode.this.content;
            }

            @Override
            public String set(String value) {
                GuiTextNode.this.content = value;
                GuiTextNode.this.getLayoutManager().markDirty();
                GuiTextNode.this.clearContext();
                return value;
            }
        });
    }

    @Override
    public void render(Object source, RenderContext context) {
        super.render(source, context);
        LayoutNode layout = this.getLayoutManager().getSourceNode(source);
        LayoutBox box = layout.getPosition();
        if (this.context == null || this.attributes.get("color") != this.color) {
            this.context = new TextContext(font, this.content);
            String colorAttr = this.attributes.get("color");
            if (colorAttr != null && colorAttr.startsWith("#") && colorAttr.length() == 7) {
                this.context.setColor(SimpleColor.fromHexString(colorAttr.substring(1)));
            }
            this.color = this.attributes.get("color");
        }
        if (context.getContextType() == RenderContext.RenderContextType.SCREEN) {
            this.context.setPosition(box.x, box.y, 0.0f);
            this.initContext(box, 1);
            context.pose().m_85836_();
            this.context.renderToGui(context.pose());
            context.pose().m_85849_();
        } else {
            this.context.setPosition(box.x, -box.y, 0.0f);
            this.initContext(box, 1);
            context.pose().m_85836_();
            context.pose().m_85837_(0.0, 0.0, 0.5);
            this.context.withoutSizeFixure();
            this.context.renderToWorld(context.pose(), context.getBufferSource(), context.getLight());
            context.pose().m_85849_();
        }
    }

    private void initContext(LayoutBox box, int initalScale) {
        this.context.setPivot(PivotPosition.fromString(this.attributes.get("textAlign")));
        float fontSize = 8.0f;
        float fontWidth = 1.0f;
        try {
            fontSize = Float.parseFloat(this.attributes.get("fontSize", "8"));
            fontWidth = Float.parseFloat(this.attributes.get("fontWidth", "1"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.context.setScale(fontWidth * (float)initalScale * fontSize / 8.0f, (float)initalScale * fontSize / 8.0f);
    }

    @Override
    public Optional<YogaMeasureFunction> measure() {
        return Optional.of((node, width, widthMode, height, heightMode) -> {
            float finalWidth;
            Pair<Integer, Integer> result = this.measureResult.get();
            int measuredWidth = result.getFirst();
            int measuredHeight = result.getSecond();
            float f = widthMode == YogaMeasureMode.EXACTLY ? width : (finalWidth = widthMode == YogaMeasureMode.AT_MOST ? Math.min(width, (float)measuredWidth) : (float)measuredWidth);
            float finalHeight = heightMode == YogaMeasureMode.EXACTLY ? height : (heightMode == YogaMeasureMode.AT_MOST ? Math.min(height, (float)measuredHeight) : (float)measuredHeight);
            return YogaMeasureOutput.make(finalWidth, finalHeight);
        });
    }

    @Override
    protected void fontSizeUpdated() {
        this.measureResult.clear();
        ((LayoutContext)this.layoutManager.get()).markDirty();
    }

    protected void clearContext() {
        ((GuiContext)this.getDomContext()).queueDuringRender(() -> {
            this.context = null;
        });
    }
}

