/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles;

import kasuga.lib.core.util.data_type.Pair;

public enum PixelUnit {
    INVALID("invalid"),
    NATIVE(""),
    PERCENTAGE("%");

    public static final PixelUnit[] SEARCH_ORDER;
    private final String suffix;

    public static Pair<Float, PixelUnit> parse(String pixelValue) {
        for (PixelUnit pixelUnit : SEARCH_ORDER) {
            if (!pixelUnit.isUnit(pixelValue)) continue;
            String val = pixelValue.substring(0, pixelValue.length() - pixelUnit.getSuffix().length()).trim();
            Float numericValue = null;
            try {
                numericValue = Float.valueOf(Float.parseFloat(val));
            }
            catch (NumberFormatException e) {
                continue;
            }
            return Pair.of(numericValue, pixelUnit);
        }
        return Pair.of(Float.valueOf(0.0f), INVALID);
    }

    private PixelUnit(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isUnit(String string) {
        return string.endsWith(this.suffix);
    }

    public String inUnit(float value) {
        return String.valueOf(value) + this.suffix;
    }

    public String toString(float value) {
        String stringValue = String.valueOf(value);
        if (stringValue.endsWith(".0")) {
            stringValue = stringValue.substring(0, stringValue.length() - 2);
        }
        return stringValue + this.suffix;
    }

    static {
        SEARCH_ORDER = new PixelUnit[]{PERCENTAGE, NATIVE};
    }
}

