/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.layout;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;

public abstract class EnumStyle<E>
extends Style<E, StyleTarget> {
    public final String original;
    public final E value;
    private final BiFunction<E, Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>, Boolean> validator;
    private StyleTarget target;

    public EnumStyle(E value, Function<E, StyleTarget> targetSupplier, BiFunction<E, Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>, Boolean> validator) {
        this.value = value;
        this.original = value.toString();
        this.target = targetSupplier.apply(value);
        this.validator = validator;
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.validator.apply(this.value, origin);
    }

    @Override
    public String getValueString() {
        return this.value.toString();
    }

    @Override
    public E getValue() {
        return this.value;
    }

    @Override
    public StyleTarget getTarget() {
        return this.target;
    }

    public static class EnumStyleType<E>
    implements StyleType<EnumStyle<E>, StyleTarget> {
        private final Function<String, E> parser;
        private final BiFunction<E, Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>, Boolean> validator;
        private final Function<E, StyleTarget> targetSupplier;
        public final EnumStyle<E> EMPTY;

        public EnumStyleType(Function<String, E> parser, BiFunction<E, Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>, Boolean> validator, Function<E, StyleTarget> targetSupplier, E defaultValue) {
            this.parser = parser;
            this.targetSupplier = targetSupplier;
            this.validator = validator;
            this.EMPTY = this.create(defaultValue);
        }

        @Override
        public EnumStyle<E> getDefault() {
            return this.EMPTY;
        }

        @Override
        public EnumStyle<E> create(String string) {
            final EnumStyleType type = this;
            return new EnumStyle<E>(this.parser.apply(string), this.targetSupplier, this.validator){

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }
            };
        }

        public EnumStyle<E> create(E value) {
            final EnumStyleType type = this;
            return new EnumStyle<E>(value, this.targetSupplier, this.validator){

                @Override
                public StyleType<?, StyleTarget> getType() {
                    return type;
                }
            };
        }

        public static <E extends Enum<E>> EnumStyleType<E> of(Function<String, E> parser, BiFunction<E, Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>, Boolean> validator, Function<E, StyleTarget> target, E defaultValue) {
            return new EnumStyleType<E>(parser, validator, target, defaultValue);
        }
    }
}

