/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.rendering;

import java.util.UUID;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.assets.TextureAssetProvider;
import kasuga.lib.core.client.frontend.rendering.ImageProvider;
import kasuga.lib.core.client.render.texture.StaticImage;
import kasuga.lib.core.client.render.texture.old.SimpleTexture;
import kasuga.lib.core.client.render.texture.old.WorldTexture;

public class AssetImageProvider
implements ImageProvider {
    private final String name;

    public AssetImageProvider(String name) {
        this.name = name;
    }

    @Override
    public WorldTexture getWorldTexture() {
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.isPresent()) {
            return null;
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(this.name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().containsKey(uuid)) {
            return null;
        }
        Object obj = KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().get(uuid);
        if (obj instanceof WorldTexture) {
            return (WorldTexture)obj;
        }
        return null;
    }

    @Override
    public SimpleTexture getSimpleTexture() {
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.isPresent()) {
            return null;
        }
        UUID uuid = null;
        try {
            uuid = UUID.fromString(this.name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().containsKey(uuid)) {
            return null;
        }
        Object obj = KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().get(uuid);
        if (obj instanceof WorldTexture) {
            WorldTexture worldTexture = (WorldTexture)obj;
            return worldTexture;
        }
        if (obj instanceof SimpleTexture) {
            SimpleTexture simpleTexture = (SimpleTexture)obj;
            return simpleTexture;
        }
        return null;
    }

    @Override
    public StaticImage getImage() {
        UUID id;
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.isPresent()) {
            return null;
        }
        try {
            id = UUID.fromString(this.name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().containsKey(id)) {
            return null;
        }
        Object obj = KasugaLib.STACKS.JAVASCRIPT.ASSETS.get().get(id);
        if (obj instanceof TextureAssetProvider.ImageHolder) {
            TextureAssetProvider.ImageHolder image = (TextureAssetProvider.ImageHolder)obj;
            return image.supplier().get();
        }
        return null;
    }
}

