/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface Rotationable {
    public Vector3f getPivot();

    public Vector3f getRotation();

    public boolean hasParent();

    public Rotationable getParent();

    default public RotationContext compileRotate(RotationContext context) {
        if (this.hasParent()) {
            context = this.getParent().compileRotate(context);
        }
        Vector3f offset = this.getPivot().m_122281_();
        offset.m_122267_(context.lastPivot());
        context.quaternions.forEach(arg_0 -> ((Vector3f)offset).m_122251_(arg_0));
        context.position.m_122253_(offset);
        if (!this.getRotation().equals((Object)Vector3f.f_176763_)) {
            Vector3f rotation = this.getRotation().m_122281_();
            rotation.m_122263_(-1.0f, -1.0f, 1.0f);
            Quaternion cubeRot = Quaternion.f_80118_.m_80161_();
            this.rotQuaternion(cubeRot, rotation);
            context.quaternions.add(0, cubeRot);
        }
        Vector3f pivot = this.getPivot().m_122281_();
        return new RotationContext(context.position, pivot, context.quaternions);
    }

    default public RotationContext startCompileRotate() {
        return this.compileRotate(new RotationContext(Vector3f.f_176763_.m_122281_(), Vector3f.f_176763_.m_122281_(), new LinkedList<Quaternion>()));
    }

    default public Vector3f getNearestValidPivot() {
        if (!this.getRotation().equals((Object)Vector3f.f_176763_)) {
            return this.getPivot();
        }
        if (this.hasParent()) {
            return this.getParent().getNearestValidPivot();
        }
        return Vector3f.f_176763_;
    }

    private void rotQuaternion(Quaternion quaternion, Vector3f rotDeg) {
        quaternion.m_80148_(Vector3f.f_122227_.m_122240_(rotDeg.m_122269_()));
        quaternion.m_80148_(Vector3f.f_122225_.m_122240_(rotDeg.m_122260_()));
        quaternion.m_80148_(Vector3f.f_122223_.m_122240_(rotDeg.m_122239_()));
    }

    public record RotationContext(Vector3f position, Vector3f lastPivot, List<Quaternion> quaternions) {
    }
}

