/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_instance;

import com.mojang.math.Vector3f;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.client.animation.neo_neo.VectorIOUtil;
import kasuga.lib.core.client.model.anim_instance.AnimationInstance;
import kasuga.lib.core.client.model.anim_instance.InstanceOf;
import kasuga.lib.core.client.model.anim_json.CatmullRomUtils;
import kasuga.lib.core.client.model.anim_json.KeyFrame;
import kasuga.lib.core.client.model.anim_json.LoopMode;
import kasuga.lib.core.client.model.anim_json.Pose;
import kasuga.lib.core.client.model.anim_model.AnimBone;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
@InstanceOf(value=KeyFrame.class)
public class KeyFrameInstance {
    public final KeyFrame keyFrame;
    public final AnimBone bone;
    public final AnimationInstance animation;
    private final ArrayList<Vector3f> position;
    private final ArrayList<Vector3f> rotation;
    private final ArrayList<Vector3f> scale;
    private final float posStartSec;
    private final float posEndSec;
    private final float rotStartSec;
    private final float rotEndSec;
    private final float scaleStartSec;
    private final float scaleEndSec;
    private final Vector3f positionStart;
    private final Vector3f positionApproach;
    private final Vector3f rotationStart;
    private final Vector3f rotationApproach;
    private final Vector3f scaleStart;
    private final Vector3f scaleApproach;
    public static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);

    public KeyFrameInstance(KeyFrame keyFrame, AnimBone bone, AnimationInstance animation) {
        this.keyFrame = keyFrame;
        this.bone = bone;
        this.animation = animation;
        this.position = new ArrayList(animation.getStepCount());
        this.rotation = new ArrayList(animation.getStepCount());
        this.scale = new ArrayList(animation.getStepCount());
        List<Map.Entry<Float, Pose>> positionFrames = keyFrame.sortPositions();
        List<Map.Entry<Float, Pose>> rotationFrames = keyFrame.sortRotations();
        List<Map.Entry<Float, Pose>> scaleFrames = keyFrame.sortScale();
        if (positionFrames.isEmpty()) {
            this.posStartSec = -1.0f;
            this.posEndSec = -1.0f;
        } else if (positionFrames.size() == 1) {
            this.posEndSec = this.posStartSec = Math.max(0.0f, Math.min(animation.length, positionFrames.get(0).getKey().floatValue()));
        } else {
            this.posStartSec = Math.max(0.0f, positionFrames.get(0).getKey().floatValue());
            this.posEndSec = Math.min(animation.length, positionFrames.get(positionFrames.size() - 1).getKey().floatValue());
        }
        if (rotationFrames.isEmpty()) {
            this.rotStartSec = -1.0f;
            this.rotEndSec = -1.0f;
        } else if (rotationFrames.size() == 1) {
            this.rotEndSec = this.rotStartSec = Math.max(0.0f, Math.min(animation.length, rotationFrames.get(0).getKey().floatValue()));
        } else {
            this.rotStartSec = Math.max(0.0f, rotationFrames.get(0).getKey().floatValue());
            this.rotEndSec = Math.min(animation.length, rotationFrames.get(rotationFrames.size() - 1).getKey().floatValue());
        }
        if (scaleFrames.size() == 0) {
            this.scaleStartSec = -1.0f;
            this.scaleEndSec = -1.0f;
        } else if (scaleFrames.size() == 1) {
            this.scaleEndSec = this.scaleStartSec = Math.max(0.0f, Math.min(animation.length, scaleFrames.get(0).getKey().floatValue()));
        } else {
            this.scaleStartSec = Math.max(0.0f, scaleFrames.get(0).getKey().floatValue());
            this.scaleEndSec = Math.min(animation.length, scaleFrames.get(scaleFrames.size() - 1).getKey().floatValue());
        }
        this.compile(positionFrames, rotationFrames, scaleFrames);
        if (positionFrames.isEmpty()) {
            this.positionStart = Vector3f.f_176763_.m_122281_();
            this.positionApproach = Vector3f.f_176763_.m_122281_();
        } else {
            this.positionStart = this.posStartSec <= 0.0f ? this.position.get(0) : Vector3f.f_176763_.m_122281_();
            this.positionApproach = positionFrames.get(positionFrames.size() - 1).getValue().getPost().m_122281_();
            this.positionApproach.m_122261_(0.0625f);
        }
        if (rotationFrames.isEmpty()) {
            this.rotationStart = Vector3f.f_176763_.m_122281_();
            this.rotationApproach = Vector3f.f_176763_.m_122281_();
        } else {
            this.rotationStart = this.rotStartSec <= 0.0f ? this.rotation.get(0) : Vector3f.f_176763_.m_122281_();
            this.rotationApproach = rotationFrames.get(rotationFrames.size() - 1).getValue().getPost();
        }
        if (scaleFrames.isEmpty()) {
            this.scaleStart = ONE.m_122281_();
            this.scaleApproach = ONE.m_122281_();
        } else {
            this.scaleStart = this.scaleStartSec <= 0.0f ? this.scale.get(0) : ONE.m_122281_();
            this.scaleApproach = scaleFrames.get(scaleFrames.size() - 1).getValue().getPost();
        }
    }

    private void compile(List<Map.Entry<Float, Pose>> position, List<Map.Entry<Float, Pose>> rotation, List<Map.Entry<Float, Pose>> scale) {
        this.singleCompile(position, this.position, this.animation.getStep());
        this.position.forEach(vec -> vec.m_122261_(0.0625f));
        this.singleCompile(rotation, this.rotation, this.animation.getStep());
        this.singleCompile(scale, this.scale, this.animation.getStep());
    }

    private void singleCompile(List<Map.Entry<Float, Pose>> in, List<Vector3f> out, float step) {
        Pair<Vector3f, Float> result;
        if (in.isEmpty()) {
            return;
        }
        int length = in.size() - 1;
        float recentTime = -1.0f;
        for (int i = 0; i < length; ++i) {
            Map.Entry<Float, Pose> first = in.get(i);
            Map.Entry<Float, Pose> second = in.get(i + 1);
            float time1 = first.getKey().floatValue();
            float time2 = second.getKey().floatValue();
            if (recentTime < 0.0f) {
                recentTime = time1;
            }
            if (first.getValue().hasPre()) {
                result = KeyFrameInstance.interpolationStep(first.getValue(), recentTime, step);
                out.add(result.getFirst());
                recentTime = result.getSecond().floatValue();
                continue;
            }
            if (first.getValue().isCatmullRom() || second.getValue().isCatmullRom()) {
                if (length < 2) {
                    Pair<Vector3f[], Float> result2 = KeyFrameInstance.interpolationLinear(first.getValue().getPost(), second.getValue().getPost(), time1, time2, step, recentTime);
                    recentTime = result2.getSecond().floatValue();
                    out.addAll(Arrays.asList(result2.getFirst()));
                    continue;
                }
                Vector3f[] controlPoints = i == length - 1 ? CatmullRomUtils.last3PointsToCRSPoints(in.get(i - 1).getValue().getPost(), first.getValue().getPost(), KeyFrameInstance.getVecAsRight(second.getValue())) : (i == 0 ? CatmullRomUtils.first3PointsToCRSPoints(first.getValue().getPost(), second.getValue().getPost(), KeyFrameInstance.getVecAsRight(in.get(i + 2).getValue())) : CatmullRomUtils.genDefaultCRSPoints(in.get(i - 1).getValue().getPost(), first.getValue().getPost(), second.getValue().getPost(), KeyFrameInstance.getVecAsRight(in.get(i + 2).getValue())));
                Pair<Vector3f[], Float> points = KeyFrameInstance.interpolationCatmullRom(controlPoints, time1, time2, step, recentTime);
                recentTime = points.getSecond().floatValue();
                out.addAll(Arrays.asList(points.getFirst()));
                continue;
            }
            Pair<Vector3f[], Float> points = KeyFrameInstance.interpolationLinear(first.getValue().getPost(), second.getValue().getPost(), time1, time2, step, recentTime);
            recentTime = points.getSecond().floatValue();
            out.addAll(Arrays.asList(points.getFirst()));
        }
        Pose pose = in.get(in.size() - 1).getValue();
        if (pose.hasPre()) {
            result = KeyFrameInstance.interpolationStep(pose, recentTime, step);
            out.add(result.getFirst());
        } else {
            out.add(pose.getPost().m_122281_());
        }
    }

    public static Pair<Vector3f[], Float> interpolationLinear(Vector3f first, Vector3f last, float start, float end, float step, float recentTime) {
        float length = end - start;
        int size = (int)((end - recentTime) / step);
        float timeOffset = (recentTime - start) / length;
        Vector3f[] result = new Vector3f[size];
        Vector3f offset = last.m_122281_();
        offset.m_122267_(first);
        for (int i = 0; i < size; ++i) {
            float time = (float)i / (float)size + timeOffset;
            Vector3f o = offset.m_122281_();
            o.m_122261_(time);
            o.m_122253_(first);
            result[i] = o;
        }
        return Pair.of(result, Float.valueOf(recentTime + (float)size * step));
    }

    public static Pair<Vector3f[], Float> interpolationCatmullRom(Vector3f[] controlPoints, float start, float end, float step, float recentTime) {
        float length = end - start;
        int size = (int)((end - recentTime) / step);
        Vector3f[] result = new Vector3f[size];
        float offset = (recentTime - start) / length;
        for (int i = 0; i < size; ++i) {
            result[i] = CatmullRomUtils.applyCRS(controlPoints, (float)i / (float)size + offset);
        }
        return Pair.of(result, Float.valueOf(recentTime + (float)size * step));
    }

    public static Pair<Vector3f, Float> interpolationStep(Pose pose, float start, float step) {
        return Pair.of(pose.getPost().m_122281_(), Float.valueOf(start + step));
    }

    public static Vector3f getVecAsLeft(Pose pose) {
        return pose.getPost();
    }

    public static Vector3f getVecAsRight(Pose pose) {
        return pose.hasPre() ? pose.getPre() : pose.getPost();
    }

    public Vector3f getPosition(float sec) {
        if (sec < this.posStartSec) {
            return this.positionStart;
        }
        if (sec >= this.animation.length) {
            return switch (this.animation.loop) {
                default -> throw new IncompatibleClassChangeError();
                case LoopMode.NONE -> Vector3f.f_176763_;
                case LoopMode.HOLD_ON_LAST_FRAME -> this.positionApproach;
                case LoopMode.LOOP -> this.getPosition(sec % this.animation.length);
            };
        }
        if (sec >= this.posEndSec) {
            return this.positionApproach;
        }
        if (this.position.size() < 2) {
            return this.position.get(0);
        }
        int index = (int)((sec - this.posStartSec) * (float)this.animation.frameRate);
        if (index >= this.position.size() - 1) {
            return this.position.get(this.position.size() - 1);
        }
        float time = (float)index * this.animation.getStep();
        float percentage = (sec - this.posStartSec - time) / this.animation.getStep();
        return KeyFrameInstance.slerp(this.position.get(index), this.position.get(index + 1), percentage);
    }

    public Vector3f getRotation(float sec) {
        if (sec < this.rotStartSec) {
            return this.rotationStart;
        }
        if (sec >= this.animation.length) {
            return switch (this.animation.loop) {
                default -> throw new IncompatibleClassChangeError();
                case LoopMode.NONE -> Vector3f.f_176763_;
                case LoopMode.HOLD_ON_LAST_FRAME -> this.rotationApproach;
                case LoopMode.LOOP -> this.getRotation(sec % this.animation.length);
            };
        }
        if (sec >= this.rotEndSec) {
            return this.rotationApproach;
        }
        if (this.rotation.size() < 2) {
            return this.rotation.get(0);
        }
        int index = (int)((sec - this.rotStartSec) * (float)this.animation.frameRate);
        if (index >= this.rotation.size() - 1) {
            return this.rotation.get(this.rotation.size() - 1);
        }
        float time = (float)index * this.animation.getStep();
        float percentage = (sec - this.rotStartSec - time) / this.animation.getStep();
        return KeyFrameInstance.slerp(this.rotation.get(index), this.rotation.get(index + 1), percentage);
    }

    public Vector3f getScale(float sec) {
        if (sec < this.scaleStartSec) {
            return this.scaleStart;
        }
        if (sec >= this.animation.length) {
            return switch (this.animation.loop) {
                default -> throw new IncompatibleClassChangeError();
                case LoopMode.NONE -> ONE;
                case LoopMode.HOLD_ON_LAST_FRAME -> this.scaleApproach;
                case LoopMode.LOOP -> this.getScale(sec % this.animation.length);
            };
        }
        if (sec >= this.scaleEndSec) {
            return this.scaleApproach;
        }
        if (this.scale.size() < 2) {
            return this.scale.get(0);
        }
        int index = (int)((sec - this.scaleStartSec) * (float)this.animation.frameRate);
        if (index >= this.scale.size() - 1) {
            return this.scale.get(this.scale.size() - 1);
        }
        float time = (float)index * this.animation.getStep();
        float percentage = (sec - this.scaleStartSec - time) / this.animation.getStep();
        return KeyFrameInstance.slerp(this.scale.get(index), this.scale.get(index + 1), percentage);
    }

    public static Vector3f slerp(Vector3f first, Vector3f second, float percentage) {
        Vector3f result = second.m_122281_();
        result.m_122267_(first);
        result.m_122261_(percentage);
        result.m_122253_(first);
        return result;
    }

    public void applyToBone(float sec) {
        if (this.posStartSec >= 0.0f && this.posEndSec >= 0.0f) {
            this.bone.setOffset(this.getPosition(sec));
        }
        if (this.rotStartSec >= 0.0f && this.rotEndSec >= 0.0f) {
            this.bone.setAnimRot(this.getRotation(sec));
        }
        if (this.scaleStartSec >= 0.0f && this.scaleEndSec >= 0.0f) {
            this.bone.setScale(this.getScale(sec));
        }
    }

    public Triple<Vector3f, Vector3f, Vector3f> getVectors(float sec) {
        Vector3f translation = this.posStartSec >= 0.0f && this.posEndSec >= 0.0f ? this.getPosition(sec) : Vector3f.f_176763_.m_122281_();
        Vector3f rotation = this.rotStartSec >= 0.0f && this.rotEndSec >= 0.0f ? this.getRotation(sec) : Vector3f.f_176763_.m_122281_();
        Vector3f scale = this.scaleStartSec >= 0.0f && this.scaleEndSec >= 0.0f ? this.getScale(sec) : ONE.m_122281_();
        return Triple.of((Object)translation, (Object)rotation, (Object)scale);
    }

    public boolean canBeRemoved() {
        return this.posStartSec == -1.0f && this.posEndSec == -1.0f && this.rotStartSec == -1.0f && this.rotEndSec == -1.0f && this.scaleStartSec == -1.0f && this.scaleEndSec == -1.0f;
    }

    public void writeToCache(ByteArrayOutputStream stream) throws IOException {
        String frameName = this.keyFrame.bone;
        byte[] fnb = frameName.getBytes(StandardCharsets.UTF_8);
        AnimationInstance.write4Bytes(fnb.length, stream);
        stream.write(fnb);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.posStartSec), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.posEndSec), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.rotStartSec), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.rotEndSec), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.scaleStartSec), stream);
        AnimationInstance.write4Bytes(Float.floatToIntBits(this.scaleEndSec), stream);
        VectorIOUtil.writeVec3fToStream(this.positionStart, stream);
        VectorIOUtil.writeVec3fToStream(this.positionApproach, stream);
        VectorIOUtil.writeVec3fToStream(this.rotationStart, stream);
        VectorIOUtil.writeVec3fToStream(this.rotationApproach, stream);
        VectorIOUtil.writeVec3fToStream(this.scaleStart, stream);
        VectorIOUtil.writeVec3fToStream(this.scaleApproach, stream);
        AnimationInstance.write4Bytes(this.position.size(), stream);
        AnimationInstance.write4Bytes(this.rotation.size(), stream);
        AnimationInstance.write4Bytes(this.scale.size(), stream);
        for (Vector3f vector3f : this.position) {
            VectorIOUtil.writeVec3fToStream(vector3f, stream);
        }
        for (Vector3f vector3f : this.rotation) {
            VectorIOUtil.writeVec3fToStream(vector3f, stream);
        }
        for (Vector3f v : this.scale) {
            VectorIOUtil.writeVec3fToStream(v, stream);
        }
    }

    public KeyFrameInstance(AnimationInstance instance, ByteArrayInputStream stream) throws IOException {
        int i;
        this.animation = instance;
        int fnbLength = AnimationInstance.read4Bytes(stream);
        byte[] fnb = stream.readNBytes(fnbLength);
        String n = new String(fnb, StandardCharsets.UTF_8);
        this.keyFrame = instance.animation.getFrame(n);
        this.bone = (AnimBone)instance.model.getChild(n);
        this.posStartSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.posEndSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.rotStartSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.rotEndSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.scaleStartSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.scaleEndSec = Float.intBitsToFloat(AnimationInstance.read4Bytes(stream));
        this.positionStart = VectorIOUtil.getVec3fFromStream(stream);
        this.positionApproach = VectorIOUtil.getVec3fFromStream(stream);
        this.rotationStart = VectorIOUtil.getVec3fFromStream(stream);
        this.rotationApproach = VectorIOUtil.getVec3fFromStream(stream);
        this.scaleStart = VectorIOUtil.getVec3fFromStream(stream);
        this.scaleApproach = VectorIOUtil.getVec3fFromStream(stream);
        int posSize = AnimationInstance.read4Bytes(stream);
        int rotSize = AnimationInstance.read4Bytes(stream);
        int scaleSize = AnimationInstance.read4Bytes(stream);
        this.position = new ArrayList(posSize);
        this.rotation = new ArrayList(rotSize);
        this.scale = new ArrayList(scaleSize);
        for (i = 0; i < posSize; ++i) {
            this.position.add(VectorIOUtil.getVec3fFromStream(stream));
        }
        for (i = 0; i < rotSize; ++i) {
            this.rotation.add(VectorIOUtil.getVec3fFromStream(stream));
        }
        for (i = 0; i < scaleSize; ++i) {
            this.scale.add(VectorIOUtil.getVec3fFromStream(stream));
        }
    }
}

