/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.client.model.BedrockRenderable;
import kasuga.lib.core.client.model.anim_model.AnimBone;
import kasuga.lib.core.client.model.anim_model.AnimModel;
import kasuga.lib.core.client.model.model_json.Cube;
import kasuga.lib.core.client.render.SimpleColor;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimCube
implements BedrockRenderable {
    public final Cube cube;
    private final List<BakedQuad> quads;
    public final AnimModel model;
    private final AnimBone bone;
    private final Vector3f pivot;
    private final Vector3f rotation;

    public AnimCube(Cube cube, AnimModel model, AnimBone bone) {
        this.cube = cube;
        Vector3f pos = cube.getPivot().m_122281_();
        pos.m_122261_(-0.0625f);
        this.quads = cube.getBaked(model.material.m_119204_(), pos);
        this.pivot = cube.getPivot().m_122281_();
        this.pivot.m_122261_(0.0625f);
        this.rotation = cube.getRotation().m_122281_();
        this.model = model;
        this.bone = bone;
    }

    protected AnimCube(Cube cube, List<BakedQuad> quads, AnimModel model, AnimBone bone, Vector3f pivot, Vector3f rotation) {
        this.cube = cube;
        this.quads = new ArrayList<BakedQuad>(quads.size());
        this.quads.addAll(quads);
        this.model = model;
        this.bone = bone;
        this.pivot = pivot.m_122281_();
        this.rotation = rotation.m_122281_();
    }

    @Override
    @Deprecated
    public Map<String, BedrockRenderable> getChildrens() {
        return Map.of();
    }

    @Override
    public void applyTranslationAndRotation(PoseStack pose) {
        Vector3f translation = this.pivot.m_122281_();
        Vector3f parentTrans = this.bone.getPivot().m_122281_();
        Vector3f t = this.vonvertPivot(translation, parentTrans);
        pose.m_85837_((double)t.m_122239_(), (double)t.m_122260_(), (double)t.m_122269_());
        Vector3f rotation = this.rotation.m_122281_();
        if (rotation.equals((Object)Vector3f.f_176763_)) {
            return;
        }
        pose.m_85845_(Vector3f.f_122227_.m_122240_(rotation.m_122269_()));
        pose.m_85845_(Vector3f.f_122224_.m_122240_(rotation.m_122260_()));
        pose.m_85845_(Vector3f.f_122222_.m_122240_(rotation.m_122239_()));
    }

    @Override
    @Deprecated
    public BedrockRenderable getChild(String name) {
        return null;
    }

    @Override
    public void render(PoseStack pose, VertexConsumer consumer, SimpleColor color, int light, int overlay) {
        pose.m_85836_();
        this.applyTranslationAndRotation(pose);
        this.quads.forEach(baked -> consumer.m_85987_(pose.m_85850_(), baked, color.getfR(), color.getfG(), color.getfB(), light, overlay));
        pose.m_85849_();
    }

    public AnimCube copy(AnimModel model, AnimBone bone) {
        return new AnimCube(this.cube, this.quads, model, bone, this.pivot, this.rotation);
    }
}

