/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.model_json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GeometryDescription {
    private final String identifier;
    private final float textureWidth;
    private final float textureHeight;
    private final float visibleBoundsWidth;
    private final float visibleBoundsHeight;
    private final Vector3f visibleBoundsOffset;

    public GeometryDescription(JsonObject json) {
        this.identifier = json.get("identifier").getAsString();
        this.textureWidth = json.get("texture_width").getAsFloat();
        this.textureHeight = json.get("texture_height").getAsFloat();
        this.visibleBoundsWidth = json.get("visible_bounds_width").getAsFloat();
        this.visibleBoundsHeight = json.get("visible_bounds_height").getAsFloat();
        JsonArray array = json.getAsJsonArray("visible_bounds_offset");
        this.visibleBoundsOffset = new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    }

    public float getTextureHeight() {
        return this.textureHeight;
    }

    public float getTextureWidth() {
        return this.textureWidth;
    }

    public float getVisibleBoundsHeight() {
        return this.visibleBoundsHeight;
    }

    public float getVisibleBoundsWidth() {
        return this.visibleBoundsWidth;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Vector3f getVisibleBoundsOffset() {
        return this.visibleBoundsOffset;
    }
}

