/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class PoseContext {
    private final Queue<Action> list = new LinkedBlockingQueue<Action>();
    private boolean lock;
    private boolean autoClear = true;

    protected PoseContext() {
    }

    protected PoseContext(Action ... acts) {
        this();
        this.list.addAll(List.of(acts));
    }

    public static PoseContext of(Action ... acts) {
        return new PoseContext(acts);
    }

    public static PoseContext of() {
        return new PoseContext();
    }

    public PoseContext addAct(Action act) {
        this.list.add(act);
        return this;
    }

    public void rotateX(float x_rotation) {
        this.addAct(stack -> stack.m_85845_(Vector3f.f_122223_.m_122240_(x_rotation)));
    }

    public void rotateY(float y_rotation) {
        this.addAct(stack -> stack.m_85845_(Vector3f.f_122225_.m_122240_(y_rotation)));
    }

    public void rotateZ(float z_rotation) {
        this.addAct(stack -> stack.m_85845_(Vector3f.f_122227_.m_122240_(z_rotation)));
    }

    public void translate(double x, double y, double z) {
        this.addAct(stack -> stack.m_85837_(x, y, z));
    }

    public void scale(float x, float y, float z) {
        this.addAct(stack -> stack.m_85841_(x, y, z));
    }

    public void setAutoClear(boolean autoClear) {
        this.autoClear = autoClear;
    }

    public boolean isAutoClear() {
        return this.autoClear;
    }

    public void apply(PoseStack stack) {
        if (this.lock) {
            return;
        }
        for (Action act : this.list) {
            act.action(stack);
        }
        if (this.autoClear) {
            this.list.clear();
        }
    }

    public void setLock(boolean locked) {
        this.lock = locked;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public static interface Action {
        public void action(PoseStack var1);
    }

    public static enum ActionType {
        TRANSLATE,
        X_ROT,
        Y_ROT,
        Z_ROT,
        SCALE,
        POINT_TO;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case TRANSLATE -> "translate";
                case X_ROT -> "x_rot";
                case Y_ROT -> "y_rot";
                case Z_ROT -> "z_rot";
                case SCALE -> "scale";
                case POINT_TO -> "point_to";
            };
        }

        public static ActionType fromString(String codec) {
            return switch (codec) {
                case "translate" -> TRANSLATE;
                case "x_rot" -> X_ROT;
                case "y_rot" -> Y_ROT;
                case "z_rot" -> Z_ROT;
                case "scale" -> SCALE;
                case "point_to" -> POINT_TO;
                default -> throw new IllegalStateException("Unexpected value: " + codec);
            };
        }
    }
}

