/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render;

import java.awt.Color;
import net.minecraft.nbt.CompoundTag;

public class SimpleColor {
    Color color;

    protected SimpleColor(Color color) {
        this.color = color;
    }

    public SimpleColor copy() {
        return SimpleColor.fromRGBA(this.getR(), this.getG(), this.getB(), this.getA());
    }

    public static SimpleColor fromRGBA(int r, int g, int b, float a) {
        return new SimpleColor(new Color(r, g, b, (int)(a * 255.0f)));
    }

    public static SimpleColor fromRGBA(int r, int g, int b, int a) {
        return new SimpleColor(new Color(r, g, b, a));
    }

    public static SimpleColor fromRGBA(int rgb, float a) {
        return SimpleColor.fromRGBAInt((int)(a * 255.0f) * 256 * 256 * 256 + rgb);
    }

    public static SimpleColor fromHexString(String hex) {
        int[] color = SimpleColor.hexToRgba(hex);
        return SimpleColor.fromRGBA(color[0], color[1], color[2], color[3]);
    }

    public static SimpleColor fromRGB(float r, float g, float b) {
        return SimpleColor.fromRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), 1);
    }

    public static SimpleColor fromRGBInt(int rgb) {
        return new SimpleColor(new Color(rgb));
    }

    public static SimpleColor fromRGBAInt(int rgba) {
        return new SimpleColor(new Color(rgba, rgba > 0xFFFFFF));
    }

    public static SimpleColor fromHSV(float h, float s, float v) {
        return SimpleColor.fromHSVA(h, s, v, 1.0f);
    }

    public static SimpleColor fromHSVA(float h, float s, float v, float a) {
        float[] rgb = SimpleColor.hsvToRgb(h, s, v);
        return new SimpleColor(new Color((int)rgb[0], (int)rgb[1], (int)rgb[2], (int)(a * 255.0f)));
    }

    public static SimpleColor fromHSI(float h, float s, float i) {
        return SimpleColor.fromHSIA(h, s, i, 1.0f);
    }

    public static SimpleColor fromHSIA(float h, float s, float i, float a) {
        float[] rgb = SimpleColor.hsiToRgb(h, s, i);
        return new SimpleColor(new Color((int)rgb[0], (int)rgb[1], (int)rgb[2], (int)(a * 255.0f)));
    }

    public SimpleColor setR(int red) {
        return SimpleColor.fromRGBA(red, this.getG(), this.getB(), this.getA());
    }

    public SimpleColor setG(int green) {
        return SimpleColor.fromRGBA(this.getR(), green, this.getB(), this.getA());
    }

    public SimpleColor setB(int blue) {
        return SimpleColor.fromRGBA(this.getR(), this.getG(), blue, this.getA());
    }

    public SimpleColor setA(float alpha) {
        return SimpleColor.fromRGBA(this.getR(), this.getG(), this.getB(), alpha);
    }

    public static SimpleColor fromNbt(CompoundTag tag) {
        return SimpleColor.fromRGBA(tag.m_128451_("red"), tag.m_128451_("green"), tag.m_128451_("blue"), tag.m_128457_("alpha"));
    }

    public void toNbt(CompoundTag tag) {
        tag.m_128405_("red", this.getR());
        tag.m_128405_("green", this.getG());
        tag.m_128405_("blue", this.getB());
        tag.m_128350_("alpha", this.getA());
    }

    public int getR() {
        return this.color.getRed();
    }

    public float getfR() {
        return (float)this.getR() / 255.0f;
    }

    public int getG() {
        return this.color.getGreen();
    }

    public float getfG() {
        return (float)this.getG() / 255.0f;
    }

    public int getB() {
        return this.color.getBlue();
    }

    public float getfB() {
        return (float)this.getB() / 255.0f;
    }

    public float getA() {
        return (float)this.color.getAlpha() / 256.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public int getRGB() {
        return this.color.getRGB();
    }

    public int getRGBA() {
        return this.color.getRGB() * 256 + this.color.getAlpha();
    }

    public float[] getHSI() {
        return SimpleColor.rgbToHsi(this.getR(), this.getG(), this.getB());
    }

    public float[] getHSV() {
        return SimpleColor.rgbToHsv(this.getR(), this.getG(), this.getB());
    }

    public static float[] hsiToRgb(float h, float s, float i) {
        float g;
        float r;
        float b;
        while (h < 0.0f) {
            h += 360.0f;
        }
        if ((h %= 360.0f) >= 0.0f && h < 120.0f) {
            b = i * (1.0f - s);
            r = i * (float)(1.0 + (double)s * Math.cos(h) / Math.cos(1.0471975511965976 - (double)h));
            g = 3.0f * i - (r + b);
        } else if (h >= 120.0f && h < 240.0f) {
            r = i * (1.0f - s);
            g = i * (float)(1.0 + (double)s * Math.cos(h -= 120.0f) / Math.cos(1.0471975511965976 - (double)h));
            b = 3.0f * i - (r + g);
        } else {
            g = i * (1.0f - s);
            b = i * (float)(1.0 + (double)s * Math.cos(h -= 240.0f) / Math.cos(1.0471975511965976 - (double)h));
            r = 3.0f * i - (g + b);
        }
        return new float[]{r, g, b};
    }

    public static float[] hsvToRgb(float h, float s, float v) {
        while (h < 0.0f) {
            h += 360.0f;
        }
        float c = v * s;
        float x = c * (1.0f - Math.abs((h %= 360.0f) / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h >= 0.0f && h < 60.0f) {
            r1 = c;
            g1 = x;
            b1 = 0.0f;
        } else if (h >= 60.0f && h < 120.0f) {
            r1 = x;
            g1 = c;
            b1 = 0.0f;
        } else if (h >= 120.0f && h < 180.0f) {
            r1 = 0.0f;
            g1 = c;
            b1 = x;
        } else if (h >= 180.0f && h < 240.0f) {
            r1 = 0.0f;
            g1 = x;
            b1 = c;
        } else if (h >= 240.0f && h < 300.0f) {
            r1 = x;
            g1 = 0.0f;
            b1 = c;
        } else if (h >= 300.0f && h < 360.0f) {
            r1 = c;
            g1 = 0.0f;
            b1 = x;
        }
        return new float[]{(r1 + m) * 255.0f, (g1 + m) * 255.0f, (b1 + m) * 255.0f};
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float cMin;
        float delta;
        float h = 0.0f;
        float s = 0.0f;
        float v = 0.0f;
        float cMax = Math.max(Math.max(r, g /= 255.0f), b /= 255.0f);
        h = (delta = cMax - (cMin = Math.min(Math.min(r /= 255.0f, g), b))) == 0.0f ? 0.0f : (cMax == r ? 60.0f * ((g - b) / delta % 6.0f) : (cMax == g ? 60.0f * ((b - r) / delta + 2.0f) : 60.0f * ((r - g) / delta + 4.0f)));
        s = cMax == 0.0f ? 0.0f : delta / cMax;
        v = cMax;
        return new float[]{h, s, v};
    }

    public static float[] rgbToHsi(float r, float g, float b) {
        float theta = (float)Math.acos(0.5 * (double)(2.0f * r - g - b) / Math.sqrt(Math.pow(r - g, 2.0) + (double)((r - b) * (g - b))));
        float i = (r + g + b) / 3.0f;
        float s = 1.0f - Math.min(r, Math.min(g, b)) / i;
        float h = b <= g ? theta : 360.0f - theta;
        return new float[]{h, s, i};
    }

    public static int[] hexToRgba(String hexString) {
        try {
            switch (hexString.length()) {
                case 3: {
                    return new int[]{Integer.parseInt(hexString.substring(0, 1)), Integer.parseInt(hexString.substring(1, 2)), Integer.parseInt(hexString.substring(2, 3)), 1};
                }
                case 4: {
                    return new int[]{Integer.parseInt(hexString.substring(0, 1), 16), Integer.parseInt(hexString.substring(1, 2), 16), Integer.parseInt(hexString.substring(2, 3), 16), Integer.parseInt(hexString.substring(3, 4), 16)};
                }
                case 6: {
                    return new int[]{Integer.parseInt(hexString.substring(0, 2), 16), Integer.parseInt(hexString.substring(2, 4), 16), Integer.parseInt(hexString.substring(4, 6), 16), 1};
                }
                case 8: {
                    return new int[]{Integer.parseInt(hexString.substring(0, 2), 16), Integer.parseInt(hexString.substring(2, 4), 16), Integer.parseInt(hexString.substring(4, 6), 16), Integer.parseInt(hexString.substring(6, 8), 16)};
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new int[]{0, 0, 0, 0};
    }
}

