/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import java.util.function.Consumer;
import kasuga.lib.core.client.render.PoseContext;

public abstract class GraphicsImage<T extends GraphicsImage> {
    protected float uOffset = 0.0f;
    protected float vOffset = 0.0f;
    protected float uWidth = 0.0f;
    protected float vHeight = 0.0f;
    protected float imageHeight = 0.0f;
    protected float imageWidth = 0.0f;
    protected float uOffsetUVCache = 0.0f;
    protected float vOffsetUVCache = 0.0f;
    protected float uWidthUVCache = 0.0f;
    protected float vHeightUVCache = 0.0f;
    protected float pivotX = 0.0f;
    protected float pivotY = 0.0f;
    PoseContext poseContext = PoseContext.of();

    protected GraphicsImage(float uOffset, float vOffset, float uWidth, float vHeight, float imageWidth, float imageHeight) {
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.imageHeight = imageHeight;
        this.imageWidth = imageWidth;
    }

    public void setUV(float uOffset, float vOffset, float uWidth, float vHeight) {
        if (!Float.isNaN(uOffset)) {
            this.uOffset = uOffset;
            this.uOffsetUVCache = uOffset / this.imageWidth;
        }
        if (!Float.isNaN(vOffset)) {
            this.vOffset = vOffset;
            this.vOffsetUVCache = vOffset / this.imageHeight;
        }
        if (!Float.isNaN(uWidth)) {
            this.uWidth = uWidth;
            this.uWidthUVCache = uWidth / this.imageWidth;
        }
        if (!Float.isNaN(vOffset)) {
            this.vOffset = vHeight;
            this.vHeightUVCache /= this.imageHeight;
        }
    }

    public void refreshUV() {
        this.uOffsetUVCache = this.uOffset / this.imageWidth;
        this.vOffsetUVCache = this.vOffset / this.imageHeight;
        this.uWidthUVCache = this.uWidth / this.imageWidth;
        this.vHeightUVCache = this.vOffset / this.imageHeight;
    }

    public abstract T cloneTexture();

    public T withClone(Consumer<T> modifier) {
        T newTexture = this.cloneTexture();
        modifier.accept(newTexture);
        return newTexture;
    }

    public T uv(float uOffset, float vOffset, float uWidth, float vHeight) {
        return (T)this.withClone(t -> t.setUV(uOffset, vOffset, uWidth, vHeight));
    }

    public void setFlipX() {
        this.setUV(this.uOffset + this.uWidth, Float.NaN, -this.uWidth, Float.NaN);
    }

    public void setFlipY() {
        this.setUV(Float.NaN, this.vOffset + this.vHeight, Float.NaN, -this.vHeight);
    }

    public T flipX() {
        return (T)this.withClone(t -> t.setFlipX());
    }

    public T flipY() {
        return (T)this.withClone(t -> t.setFlipY());
    }

    public void setCropping(int left, int top, int right, int down) {
        this.uOffset += (float)left;
        this.vOffset += (float)top;
        this.uWidth -= (float)(left + right);
        this.vHeight -= (float)(top + down);
        this.refreshUV();
    }

    public T crop(int left, int top, int right, int down) {
        return (T)this.withClone(t -> t.setCropping(left, top, right, down));
    }

    public void setSubImage(int left, int top, int width, int height) {
        this.uOffset += (float)left;
        this.vOffset += (float)top;
        this.uWidth = width;
        this.vHeight = height;
        this.refreshUV();
    }

    public T subImage(int left, int top, int width, int height) {
        return (T)this.withClone(t -> t.setCropping(left, top, width, height));
    }

    public PoseContext getPoseContext() {
        return this.poseContext;
    }

    public T withPoseContext(PoseContext context) {
        return (T)this.withClone(t -> {
            t.poseContext = context;
        });
    }
}

