/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import kasuga.lib.core.annos.Util;
import kasuga.lib.core.client.render.texture.ImageMask;
import kasuga.lib.core.client.render.texture.Matrix;
import kasuga.lib.core.client.render.texture.StaticImage;
import kasuga.lib.core.client.render.texture.Vec2f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;

public class NineSlicedImageMask
extends ImageMask {
    float left;
    float right;
    float top;
    float bottom;
    float scalingFactor = 1.0f;
    private final Matrix<Vec2f> matrix;
    private final Matrix<Vector3f> positionMatrix;

    public NineSlicedImageMask(StaticImage image) {
        super(image);
        this.matrix = new Matrix(4, 4);
        this.positionMatrix = new Matrix(4, 4);
        this.updateMatrix();
    }

    public NineSlicedImageMask(NineSlicedImageMask mask) {
        super(mask);
        this.left = mask.left;
        this.right = mask.right;
        this.top = mask.top;
        this.bottom = mask.bottom;
        this.matrix = new Matrix(4, 4);
        this.positionMatrix = new Matrix(4, 4);
        this.updateMatrix();
    }

    public NineSlicedImageMask(String name, CompoundTag nbt) {
        super(name, nbt);
        CompoundTag tag = nbt.m_128469_(name);
        this.left = tag.m_128457_("left");
        this.right = tag.m_128457_("right");
        this.top = tag.m_128457_("top");
        this.bottom = tag.m_128457_("bottom");
        this.matrix = new Matrix(4, 4);
        this.positionMatrix = new Matrix(4, 4);
        this.updateMatrix();
    }

    @Override
    public void serialize(String name, CompoundTag nbt) {
        super.serialize(name, nbt);
        CompoundTag tag = nbt.m_128469_(name);
        tag.m_128350_("left", this.left);
        tag.m_128350_("right", this.right);
        tag.m_128350_("top", this.top);
        tag.m_128350_("bottom", this.bottom);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.left = 0.1f;
        this.right = 0.9f;
        this.top = 0.1f;
        this.bottom = 0.9f;
    }

    public void setScalingFactor(float factor) {
        this.scalingFactor = factor;
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public void updateMatrix() {
        this.matrix.set(1, 1, this.getUvLeftTop());
        this.matrix.set(1, 4, this.getUvRightTop());
        this.matrix.set(4, 1, this.getUvLeftDown());
        this.matrix.set(4, 4, this.getUvRightDown());
        this.matrix.set(1, 2, Vec2f.sampling(this.getUvLeftTop(), this.getUvRightTop(), this.left));
        this.matrix.set(1, 3, Vec2f.sampling(this.getUvLeftTop(), this.getUvRightTop(), this.right));
        this.matrix.set(2, 1, Vec2f.sampling(this.getUvLeftTop(), this.getUvLeftDown(), this.top));
        this.matrix.set(3, 1, Vec2f.sampling(this.getUvLeftTop(), this.getUvLeftDown(), this.bottom));
        this.matrix.set(4, 2, Vec2f.sampling(this.getUvLeftDown(), this.getUvRightDown(), this.left));
        this.matrix.set(4, 3, Vec2f.sampling(this.getUvLeftDown(), this.getUvRightDown(), this.right));
        this.matrix.set(2, 4, Vec2f.sampling(this.getUvRightTop(), this.getUvRightDown(), this.top));
        this.matrix.set(3, 4, Vec2f.sampling(this.getUvRightTop(), this.getUvRightDown(), this.bottom));
        this.matrix.set(2, 2, Vec2f.intersection(this.matrix.get(2, 1), this.matrix.get(2, 4), this.matrix.get(1, 2), this.matrix.get(4, 2)));
        this.matrix.set(2, 3, Vec2f.intersection(this.matrix.get(2, 1), this.matrix.get(2, 4), this.matrix.get(1, 3), this.matrix.get(4, 3)));
        this.matrix.set(3, 2, Vec2f.intersection(this.matrix.get(3, 1), this.matrix.get(3, 4), this.matrix.get(1, 2), this.matrix.get(4, 2)));
        this.matrix.set(3, 3, Vec2f.intersection(this.matrix.get(3, 1), this.matrix.get(3, 4), this.matrix.get(1, 3), this.matrix.get(4, 3)));
        this.updatePositionMatrix();
    }

    public void updatePositionMatrix() {
        this.positionMatrix.set(1, 1, this.getLeftTop());
        this.positionMatrix.set(1, 4, this.getRightTop());
        this.positionMatrix.set(4, 1, this.getLeftDown());
        this.positionMatrix.set(4, 4, this.getRightDown());
        this.positionMatrix.set(1, 2, NineSlicedImageMask.cutVector3f(this.getLeftTop(), this.getRightTop(), this.matrix.get(1, 1).distance(this.matrix.get(1, 2)) * this.scalingFactor * (float)this.getImage().width()));
        this.positionMatrix.set(1, 3, NineSlicedImageMask.cutVector3f(this.getRightTop(), this.getLeftTop(), this.matrix.get(1, 3).distance(this.matrix.get(1, 4)) * this.scalingFactor * (float)this.getImage().width()));
        this.positionMatrix.set(2, 1, NineSlicedImageMask.cutVector3f(this.getLeftTop(), this.getLeftDown(), this.matrix.get(1, 1).distance(this.matrix.get(2, 1)) * this.scalingFactor * (float)this.getImage().height()));
        this.positionMatrix.set(3, 1, NineSlicedImageMask.cutVector3f(this.getLeftDown(), this.getLeftTop(), this.matrix.get(3, 1).distance(this.matrix.get(4, 1)) * this.scalingFactor * (float)this.getImage().height()));
        this.positionMatrix.set(4, 2, NineSlicedImageMask.cutVector3f(this.getLeftDown(), this.getRightDown(), this.matrix.get(4, 1).distance(this.matrix.get(4, 2)) * this.scalingFactor * (float)this.getImage().width()));
        this.positionMatrix.set(4, 3, NineSlicedImageMask.cutVector3f(this.getRightDown(), this.getLeftDown(), this.matrix.get(4, 3).distance(this.matrix.get(4, 4)) * this.scalingFactor * (float)this.getImage().width()));
        this.positionMatrix.set(2, 4, NineSlicedImageMask.cutVector3f(this.getRightTop(), this.getRightDown(), this.matrix.get(1, 4).distance(this.matrix.get(2, 4)) * this.scalingFactor * (float)this.getImage().height()));
        this.positionMatrix.set(3, 4, NineSlicedImageMask.cutVector3f(this.getRightDown(), this.getRightTop(), this.matrix.get(3, 4).distance(this.matrix.get(4, 4)) * this.scalingFactor * (float)this.getImage().height()));
        this.positionMatrix.set(2, 2, NineSlicedImageMask.intersectionVector3f(this.positionMatrix.get(2, 1), this.positionMatrix.get(2, 4), this.positionMatrix.get(1, 2), this.positionMatrix.get(4, 2)));
        this.positionMatrix.set(2, 3, NineSlicedImageMask.intersectionVector3f(this.positionMatrix.get(2, 4), this.positionMatrix.get(2, 1), this.positionMatrix.get(1, 3), this.positionMatrix.get(4, 3)));
        this.positionMatrix.set(3, 2, NineSlicedImageMask.intersectionVector3f(this.positionMatrix.get(3, 1), this.positionMatrix.get(3, 4), this.positionMatrix.get(4, 2), this.positionMatrix.get(1, 2)));
        this.positionMatrix.set(3, 3, NineSlicedImageMask.intersectionVector3f(this.positionMatrix.get(3, 4), this.positionMatrix.get(3, 1), this.positionMatrix.get(4, 3), this.positionMatrix.get(1, 3)));
    }

    public void setBorders(float left, float right, float top, float bottom) {
        this.left = left / (float)this.image.width();
        this.right = ((float)this.image.width() - right) / (float)this.image.width();
        this.top = top / (float)this.image.height();
        this.bottom = ((float)this.image.height() - bottom) / (float)this.image.height();
        this.updateMatrix();
    }

    public void setBordersDirectly(float left, float right, float top, float bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.updateMatrix();
    }

    @Override
    public NineSlicedImageMask rectangle(Vector3f leftTop, ImageMask.Axis xAxis, ImageMask.Axis yAxis, boolean xPositive, boolean yPositive, float width, float height) {
        return (NineSlicedImageMask)super.rectangle(leftTop, xAxis, yAxis, xPositive, yPositive, width, height);
    }

    @Override
    public void updateMapping() {
        if (!(this.positionMatrix.get(1, 1).equals((Object)this.getLeftTop()) && this.positionMatrix.get(1, 4).equals((Object)this.getRightTop()) && this.positionMatrix.get(4, 1).equals((Object)this.getLeftDown()) && this.positionMatrix.get(4, 4).equals((Object)this.getRightDown()))) {
            this.updatePositionMatrix();
        }
    }

    @Override
    public void renderToGui() {
        for (int y = 1; y < 4; ++y) {
            for (int x = 1; x < 4; ++x) {
                this.image.renderToGui(this.positionMatrix.get(y, x), this.positionMatrix.get(y, x + 1), this.positionMatrix.get(y + 1, x), this.positionMatrix.get(y + 1, x + 1), this.matrix.get(y, x), this.matrix.get(y, x + 1), this.matrix.get(y + 1, x), this.matrix.get(y + 1, x + 1), this.getColor());
            }
        }
    }

    @Override
    public void renderToWorld(PoseStack pose, MultiBufferSource buffer, RenderType type, boolean revert, int light) {
        if (buffer == null) {
            return;
        }
        for (int y = 1; y < 4; ++y) {
            for (int x = 1; x < 4; ++x) {
                this.image.renderToWorld(pose, buffer, type, this.positionMatrix.get(y, x), this.positionMatrix.get(y, x + 1), this.positionMatrix.get(y + 1, x), this.positionMatrix.get(y + 1, x + 1), this.matrix.get(y, x), this.matrix.get(y, x + 1), this.matrix.get(y + 1, x), this.matrix.get(y + 1, x + 1), this.getColor(), revert, light);
            }
        }
    }

    @Util
    public static Vector3f samplingVector3f(Vector3f begin, Vector3f end, float percentage) {
        Vector3f offset = end.m_122281_();
        offset.m_122267_(begin);
        offset.m_122261_(percentage);
        offset.m_122253_(begin);
        return offset;
    }

    @Util
    public static Vector3f cutVector3f(Vector3f begin, Vector3f end, float length) {
        Vector3f offset = end.m_122281_();
        offset.m_122267_(begin);
        offset.m_122278_();
        offset.m_122261_(length);
        offset.m_122253_(begin);
        return offset;
    }

    @Util
    public static Vector3f intersectionVector3f(Vector3f begin1, Vector3f end1, Vector3f begin2, Vector3f end2) {
        Vector3f a = end1.m_122281_();
        a.m_122267_(begin1);
        Vector3f b = end2.m_122281_();
        b.m_122267_(begin2);
        Vector3f t = begin2.m_122281_();
        t.m_122267_(begin1);
        float aSqr = a.m_122276_(a);
        float bSqr = b.m_122276_(b);
        float a_dot_b = a.m_122276_(b);
        float a_dot_t = a.m_122276_(t);
        float b_dot_t = b.m_122276_(t);
        float denom = aSqr * bSqr - a_dot_b * a_dot_b;
        float u = (a_dot_t * bSqr - b_dot_t * a_dot_b) / denom;
        float v = (u * a_dot_b - b_dot_t) / bSqr;
        Vector3f px = a.m_122281_();
        px.m_122261_(u);
        Vector3f p_u = begin1.m_122281_();
        p_u.m_122253_(px);
        Vector3f qx = b.m_122281_();
        qx.m_122261_(v);
        Vector3f q_v = begin2.m_122281_();
        q_v.m_122253_(qx);
        Vector3f vec = q_v.m_122281_();
        vec.m_122267_(p_u);
        float len = vec.m_122276_(vec);
        if (len == 0.0f) {
            return p_u;
        }
        return NineSlicedImageMask.average(p_u, q_v);
    }

    @Util
    public static Vector3f average(Vector3f ... vector3fs) {
        Vector3f vector3f = Vector3f.f_176763_.m_122281_();
        for (Vector3f v : vector3fs) {
            vector3f.m_122253_(v);
        }
        vector3f.m_122261_(1.0f / (float)vector3fs.length);
        return vector3f;
    }
}

