/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.texture;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.KasugaLibClient;
import kasuga.lib.core.client.render.texture.StaticImage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class StaticImageHolder {
    private final ResourceLocation id;
    private final byte[] bytes;
    private int registerType;
    private final CompoundTag nbt;
    private final FriendlyByteBuf buf;
    private Supplier<StaticImage> image;

    public StaticImageHolder(ResourceLocation id) {
        this.id = id;
        this.bytes = new byte[0];
        this.registerType = 0;
        this.nbt = null;
        this.buf = null;
    }

    public StaticImageHolder(ResourceLocation id, InputStream stream) throws IOException {
        this.id = id;
        this.bytes = stream.readAllBytes();
        this.registerType = 1;
        this.nbt = null;
        this.buf = null;
    }

    public StaticImageHolder(ResourceLocation id, byte[] bytes) {
        this.id = id;
        this.bytes = bytes;
        this.registerType = 1;
        this.nbt = null;
        this.buf = null;
    }

    public StaticImageHolder(CompoundTag nbt) {
        this.id = null;
        this.bytes = new byte[0];
        this.registerType = 2;
        this.nbt = nbt;
        this.buf = null;
    }

    public StaticImageHolder(FriendlyByteBuf buf) {
        this.id = null;
        this.bytes = new byte[0];
        this.registerType = 3;
        this.nbt = null;
        this.buf = buf;
    }

    public Supplier<StaticImage> getImage() throws IOException {
        Supplier<StaticImage> image;
        if (!KasugaLib.STACKS.isTextureRegistryFired()) {
            StaticImage.HOLDERS.add(this);
            return null;
        }
        switch (this.registerType) {
            case 0: {
                Supplier<StaticImage> supplier = StaticImage.createImage(this.id);
                break;
            }
            case 1: {
                Supplier<StaticImage> supplier = StaticImage.createImage(this.id, new ByteArrayInputStream(this.bytes));
                break;
            }
            case 2: {
                Supplier<StaticImage> supplier = StaticImage.createImage(this.nbt);
                break;
            }
            case 3: {
                Supplier<StaticImage> supplier = StaticImage.createImage(this.buf);
                break;
            }
            default: {
                Supplier<StaticImage> supplier = image = this.image;
            }
        }
        if (this.registerType > -1) {
            this.image = image;
        }
        this.registerType = -1;
        return image;
    }

    public Supplier<StaticImage> getImageSafe() {
        try {
            return this.getImage();
        }
        catch (IOException e) {
            try {
                Supplier<StaticImage> supplier = KasugaLibClient.NO_IMG.getImage();
                return supplier;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            finally {
                KasugaLib.MAIN_LOGGER.warn("Failed to get specified picture!", (Throwable)e);
            }
        }
    }
}

