/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.ItemReg;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator<T extends AbstractBogeyBlock<?>> {
    private final List<BlockReg.PropertyIdentifier> identifiers;
    private final NonNullSupplier<Block> initBlock;
    private HarvestProperty harvest = HarvestProperty.PICKAXE;
    private String modelPath = "";
    private Supplier<ItemLike> dropItem = () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get();

    public BlockStateGenerator(NonNullSupplier<Block> initialBlock) {
        this.initBlock = initialBlock;
        this.identifiers = new ArrayList<BlockReg.PropertyIdentifier>();
    }

    public BlockStateGenerator(BlockReg<?> initialBlock) {
        this((NonNullSupplier<Block>)((NonNullSupplier)initialBlock::getBlock));
    }

    public BlockStateGenerator(RegistryObject<? extends Block> registration) {
        this((NonNullSupplier<Block>)((NonNullSupplier)() -> registration.get()));
    }

    public BlockStateGenerator(BlockEntry<?> entry) {
        this((NonNullSupplier<Block>)((NonNullSupplier)() -> entry.get()));
    }

    public static <T extends AbstractBogeyBlock<?>> BlockStateGenerator<T> ofWooden() {
        return new BlockStateGenerator<T>((NonNullSupplier<Block>)((NonNullSupplier)SharedProperties::wooden));
    }

    public static <T extends AbstractBogeyBlock<?>> BlockStateGenerator<T> ofStone() {
        return new BlockStateGenerator<T>((NonNullSupplier<Block>)((NonNullSupplier)SharedProperties::stone));
    }

    public static <T extends AbstractBogeyBlock<?>> BlockStateGenerator<T> ofSoftMetal() {
        return new BlockStateGenerator<T>((NonNullSupplier<Block>)((NonNullSupplier)SharedProperties::softMetal));
    }

    public static <T extends AbstractBogeyBlock<?>> BlockStateGenerator<T> ofCopperMetal() {
        return new BlockStateGenerator<T>((NonNullSupplier<Block>)((NonNullSupplier)SharedProperties::copperMetal));
    }

    public static <T extends AbstractBogeyBlock<?>> BlockStateGenerator<T> ofNetheriteMetal() {
        return new BlockStateGenerator<T>((NonNullSupplier<Block>)((NonNullSupplier)SharedProperties::netheriteMetal));
    }

    public BlockStateGenerator<T> sound(SoundType soundType) {
        this.identifiers.add(p -> p.m_60918_(soundType));
        return this;
    }

    public BlockStateGenerator<T> noOcclusion() {
        this.identifiers.add(p -> p.m_60955_());
        return this;
    }

    public BlockStateGenerator<T> pickaxeOnly() {
        this.harvest = HarvestProperty.PICKAXE;
        return this;
    }

    public BlockStateGenerator<T> axeOnly() {
        this.harvest = HarvestProperty.AXE;
        return this;
    }

    public BlockStateGenerator<T> pickaxeOrAxe() {
        this.harvest = HarvestProperty.ALL;
        return this;
    }

    public BlockStateGenerator<T> modelPath(String path) {
        this.modelPath = path;
        return this;
    }

    public BlockStateGenerator<T> dropItem(Supplier<ItemLike> drop) {
        this.dropItem = drop;
        return this;
    }

    public BlockStateGenerator<T> dropItem(BlockReg<?> drop) {
        this.dropItem = drop::getBlock;
        return this;
    }

    public BlockStateGenerator<T> dropBlockItem(BlockReg<?> drop) {
        this.dropItem = drop::itemInstance;
        return this;
    }

    public BlockStateGenerator<T> dropItem(RegistryObject<? extends ItemLike> reg) {
        this.dropItem = () -> reg.get();
        return this;
    }

    public BlockStateGenerator<T> dropItem(ItemReg<?> drop) {
        this.dropItem = drop::getItem;
        return this;
    }

    public <B extends T, P> NonNullUnaryOperator<BlockBuilder<B, P>> build() {
        return b -> {
            b.initialProperties(this.initBlock);
            this.identifiers.forEach(identifier -> b.properties(p -> {
                identifier.apply((BlockBehaviour.Properties)p);
                return p;
            }));
            switch (this.harvest) {
                case ALL: {
                    b.transform(TagGen.pickaxeOnly());
                    break;
                }
                case AXE: {
                    b.transform(TagGen.axeOnly());
                    break;
                }
                case PICKAXE: {
                    b.transform(TagGen.pickaxeOnly());
                }
            }
            b.blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, s -> p.models().getExistingFile(p.modLoc(this.modelPath))));
            b.loot((p, l) -> p.m_124147_((Block)l, this.dropItem.get()));
            return b;
        };
    }

    public static enum HarvestProperty {
        PICKAXE,
        AXE,
        ALL;

    }
}

