/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SynchronizedThread
extends Thread {
    final Queue<Runnable> pendingTasks = new ArrayDeque<Runnable>();
    AtomicBoolean shouldShutdown = new AtomicBoolean(false);
    final AtomicInteger shouldRunTicks = new AtomicInteger(0);

    SynchronizedThread(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (!this.shouldShutdown.get()) {
                    try {
                        if (this.shouldRunTicks.get() <= 0) {
                            AtomicInteger atomicInteger = this.shouldRunTicks;
                            synchronized (atomicInteger) {
                                this.shouldRunTicks.wait();
                            }
                        }
                        if (this.shouldRunTicks.getAndUpdate(x -> x > 0 ? x - 1 : 0) > 0) {
                            this.tick();
                        }
                        if (this.pendingTasks.isEmpty()) continue block7;
                        this.pendingTasks.poll().run();
                    }
                    catch (RuntimeException e) {
                        System.out.println("An exception occurs when running the tasks");
                        e.printStackTrace();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.shouldShutdown.get()) break;
        }
        this.beforeStop();
    }

    protected abstract void tick();

    protected abstract void beforeStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchTick() {
        AtomicInteger atomicInteger = this.shouldRunTicks;
        synchronized (atomicInteger) {
            this.shouldRunTicks.incrementAndGet();
            this.shouldRunTicks.notifyAll();
        }
    }

    public void recordCall(Runnable runnable) {
        this.pendingTasks.add(runnable);
    }

    public void revokeCall(Runnable runnable) {
        this.pendingTasks.remove(runnable);
    }
}

