/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueReference;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kasuga.lib.core.javascript.engine.HostAccess;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetKasugaConverter;
import kasuga.lib.core.javascript.engine.javet.JavetValue;
import kasuga.lib.core.util.data_type.Pair;

public class JavetClassConverter {
    protected final JavetKasugaConverter converter;
    private final V8Runtime v8Runtime;
    private final V8ValueFunction setPrototypeOf;
    private final V8ValueObject globalObject;
    private final V8ValueSymbol toStringTag;

    JavetClassConverter(V8Runtime v8Runtime, JavetKasugaConverter converter) {
        this.converter = converter;
        this.v8Runtime = v8Runtime;
        try {
            this.setPrototypeOf = (V8ValueFunction)((V8ValueObject)v8Runtime.getGlobalObject().getProperty("Object")).getProperty("setPrototypeOf");
            this.globalObject = v8Runtime.getGlobalObject();
            this.toStringTag = (V8ValueSymbol)((V8ValueObject)v8Runtime.getGlobalObject().getProperty("Symbol")).get("toStringTag");
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public V8ValueObject createPrototype(V8Runtime runtime, Class<?> objectClass, HashMap<String, ArrayList<Method>> methodsFromName, HashMap<Field, Boolean> properties) {
        String protoName = "Kasuga#Proxy.ProtoType." + objectClass.getName();
        try {
            if (this.globalObject.hasPrivateProperty(protoName)) {
                return (V8ValueObject)this.globalObject.getPrivateProperty(protoName);
            }
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
        try {
            V8ValueObject prototypeObject = runtime.createV8ValueObject();
            for (Map.Entry<String, ArrayList<Method>> entry : methodsFromName.entrySet()) {
                JavetCallbackContext functionContext = new JavetCallbackContext(entry.getKey(), JavetCallbackType.DirectCallThisAndResult, (_this, args) -> {
                    if (!(_this instanceof V8ValueObject)) {
                        throw new IllegalStateException("Illegal invocation");
                    }
                    V8ValueObject v8Object = (V8ValueObject)_this;
                    try (Object _object = v8Object.getPrivateProperty("Kasuga#ProxyHandler");){
                        if (_object == null || _object.isNullOrUndefined() || !(_object instanceof V8ValueObject)) {
                            throw new IllegalStateException("Illegal invocation");
                        }
                        V8ValueObject object = (V8ValueObject)_object;
                        ArrayList<V8Value> _args = new ArrayList<V8Value>();
                        _args.add(runtime.createV8ValueString("invoke"));
                        _args.add(runtime.createV8ValueString((String)entry.getKey()));
                        if (args != null && args.length != 0) {
                            _args.addAll(List.of(args));
                        }
                        Object t = object.invoke("operate", _args.toArray());
                        return t;
                    }
                });
                prototypeObject.bindFunction(functionContext);
            }
            for (Map.Entry<Object, Serializable> entry : properties.entrySet()) {
                JavetCallbackContext getter = null;
                JavetCallbackContext setter = null;
                getter = new JavetCallbackContext(((Field)entry.getKey()).getName(), JavetCallbackType.DirectCallGetterAndThis, _this -> {
                    if (!(_this instanceof V8ValueObject)) {
                        throw new IllegalStateException("Illegal invocation");
                    }
                    V8ValueObject v8Object = (V8ValueObject)_this;
                    try (Object _object = v8Object.getPrivateProperty("Kasuga#ProxyHandler");){
                        if (_object == null || _object.isNullOrUndefined() || !(_object instanceof V8ValueObject)) {
                            throw new IllegalStateException("Illegal invocation");
                        }
                        V8ValueObject object = (V8ValueObject)_object;
                        Object t = object.invoke("operate", "get", ((Field)entry.getKey()).getName());
                        return t;
                    }
                });
                if (((Boolean)entry.getValue()).booleanValue()) {
                    setter = new JavetCallbackContext(((Field)entry.getKey()).getName(), JavetCallbackType.DirectCallSetterAndThis, (_this, value) -> {
                        if (!(_this instanceof V8ValueObject)) {
                            throw new IllegalStateException("Illegal invocation");
                        }
                        V8ValueObject v8Object = (V8ValueObject)_this;
                        try (Object _object = v8Object.getPrivateProperty("Kasuga#ProxyHandler");){
                            if (_object == null || _object.isNullOrUndefined() || !(_object instanceof V8ValueObject)) {
                                throw new IllegalStateException("Illegal invocation");
                            }
                            V8ValueObject object = (V8ValueObject)_object;
                            Object t = object.invoke("operate", "set", ((Field)entry.getKey()).getName(), value);
                            return t;
                        }
                    });
                }
                if (setter != null) {
                    prototypeObject.bindProperty(getter, setter);
                    continue;
                }
                prototypeObject.bindProperty(getter);
            }
            prototypeObject.set((Object)this.toStringTag, (Object)objectClass.getName());
            this.globalObject.setPrivateProperty(protoName, prototypeObject);
            return prototypeObject;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends AccessibleObject> List<T> getExportedAccessible(T[] sources) {
        ArrayList<T> objects = new ArrayList<T>();
        for (T source : sources) {
            Member member;
            if (!(source instanceof Member) || Modifier.isStatic((member = (Member)source).getModifiers()) || !((AccessibleObject)source).isAnnotationPresent(HostAccess.Export.class)) continue;
            objects.add(source);
        }
        return objects;
    }

    public <T> V8ValueObject generateOperationBaseForObject(V8Runtime runtime, T object, Class<T> objectClass, HashMap<String, ArrayList<Method>> methodsFromName, InvokeHandler handler) throws JavetException {
        if (methodsFromName.containsKey("apply")) {
            JavetCallbackContext callbackContext = new JavetCallbackContext("apply", JavetCallbackType.DirectCallNoThisAndResult, args -> handler.invoke(object, (ArrayList)methodsFromName.get("apply"), args));
            return runtime.createV8ValueFunction(callbackContext);
        }
        return runtime.createV8ValueObject();
    }

    public <T> V8Value generateOperationProxyForObject(V8Runtime runtime, T object, Class<T> objectClass, HashMap<String, ArrayList<Method>> methodsFromName, V8ValueObject prototype, HashMap<Field, Boolean> fields) throws JavetException {
        InvokeHandler invokeHandler = new InvokeHandler(object, methodsFromName, fields);
        V8ValueObject base = this.generateOperationBaseForObject(runtime, object, objectClass, methodsFromName, invokeHandler);
        this.setPrototypeOf.callVoid(null, base, prototype);
        prototype.close();
        V8ValueObject proxyHandler = this.createProxyHandler(runtime, object, objectClass, methodsFromName, fields, invokeHandler);
        base.setPrivateProperty("Kasuga#ProxyHandler", proxyHandler);
        proxyHandler.close();
        base.setWeak();
        return base;
    }

    private <T> V8ValueObject createProxyHandler(V8Runtime runtime, T object, Class<T> objectClass, HashMap<String, ArrayList<Method>> methodsFromName, HashMap<Field, Boolean> fields, InvokeHandler invokeHandler) throws JavetException {
        V8ValueObject proxyHandler = runtime.createV8ValueObject();
        JavetCallbackContext operateFunction = new JavetCallbackContext("operate", InvokeHandler.createFunction(invokeHandler, object), InvokeHandler.FunctionHandlerExecute);
        try (V8ValueFunction v8Function = this.v8Runtime.createV8ValueFunction(operateFunction);){
            proxyHandler.set((Object)"operate", (Object)v8Function);
        }
        proxyHandler.bindFunction(operateFunction);
        return proxyHandler;
    }

    public <T> V8Value toV8Value(V8Runtime runtime, T sourceObject) {
        Method method;
        Class<?> objectClass = sourceObject.getClass();
        List methods = this.getExportedAccessible(objectClass.getMethods());
        HashMap<String, ArrayList<Method>> methodsFromName = new HashMap<String, ArrayList<Method>>();
        for (Method method2 : methods) {
            methodsFromName.computeIfAbsent(method2.getName(), e -> new ArrayList()).add(method2);
        }
        if (!(!objectClass.isAnnotationPresent(FunctionalInterface.class) && !Arrays.stream(objectClass.getInterfaces()).anyMatch(t -> t.isAnnotationPresent(FunctionalInterface.class)) || methodsFromName.containsKey((method = objectClass.getDeclaredMethods()[0]).getName()) && ((ArrayList)methodsFromName.get(method.getName())).contains(method))) {
            methodsFromName.computeIfAbsent(method.getName(), e -> new ArrayList()).add(method);
        }
        HashMap<Field, Boolean> fields = this.getFields(objectClass);
        V8ValueObject prototype = this.createPrototype(runtime, sourceObject.getClass(), methodsFromName, fields);
        try {
            return this.generateOperationProxyForObject(runtime, sourceObject, objectClass, methodsFromName, prototype, fields);
        }
        catch (JavetException e2) {
            throw new RuntimeException(e2);
        }
    }

    private <T> HashMap<Field, Boolean> getFields(Class<T> objectClass) {
        Field[] fields = objectClass.getFields();
        HashMap<Field, Boolean> returnFields = new HashMap<Field, Boolean>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(HostAccess.Export.class)) continue;
            returnFields.put(field, !Modifier.isFinal(field.getModifiers()));
        }
        return returnFields;
    }

    protected class InvokeHandler {
        private final Object object;
        private final HashMap<String, ArrayList<Method>> methodsFromName;
        private final HashMap<Field, Boolean> fields;
        private final HashMap<String, ArrayList<Field>> fieldsByName = new HashMap();
        public static Method FunctionHandlerExecute = FunctionHandler.class.getMethods()[0];

        public <T> InvokeHandler(T object, HashMap<String, ArrayList<Method>> methodsFromName, HashMap<Field, Boolean> fields) {
            this.object = object;
            this.methodsFromName = methodsFromName;
            this.fields = fields;
            for (Field field : this.fields.keySet()) {
                this.fieldsByName.computeIfAbsent(field.getName(), n -> new ArrayList()).add(field);
            }
        }

        public V8Value invoke(Object object, ArrayList<Method> alternativeMethods, V8Value ... args) {
            List<V8Value> argsList = List.of(args);
            ArrayList<Object> converted = new ArrayList<Object>();
            try {
                for (V8Value value : argsList) {
                    converted.add(JavetClassConverter.this.converter.toObject(value));
                }
                for (Method sameNameMethod : alternativeMethods) {
                    Pair<Boolean, V8Value> callResult;
                    if (!sameNameMethod.canAccess(object) || !(callResult = this.tryInvoke(sameNameMethod, argsList, converted)).getFirst().booleanValue()) continue;
                    V8Value v8Value = callResult.getSecond();
                    if (v8Value instanceof V8ValueReference) {
                        V8ValueReference reference = (V8ValueReference)v8Value;
                        reference.setWeak();
                    }
                    return callResult.getSecond();
                }
            }
            catch (JavetException | IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("Invalid call target to " + object.getClass().getName() + "::" + alternativeMethods.get(0).getName());
        }

        public Pair<Boolean, V8Value> tryInvoke(Method method, List<V8Value> originValues, List<Object> convertedValues) throws JavetException, InvocationTargetException, IllegalAccessException {
            Parameter[] parameters = method.getParameters();
            ArrayList<Object> callParameter = new ArrayList<Object>();
            int i = 0;
            for (Parameter parameter : parameters) {
                if (parameter.getType() == JavascriptValue.class) {
                    V8Value value = JavetValue.weakClone(originValues.get(i));
                    callParameter.add(new JavetJavascriptValue(value, JavetClassConverter.this.v8Runtime));
                } else {
                    if (!parameter.getType().isAssignableFrom(convertedValues.get(i).getClass())) {
                        return Pair.of(false, null);
                    }
                    callParameter.add(convertedValues.get(i));
                }
                ++i;
            }
            Object returnValue = method.invoke(this.object, callParameter.toArray());
            return Pair.of(true, JavetClassConverter.this.converter.toV8Value(JavetClassConverter.this.v8Runtime, returnValue));
        }

        public V8Value get(Object object, V8Value name) {
            try {
                ArrayList<Field> fieldArrayList = this.fieldsByName.get(name.asString());
                if (fieldArrayList == null) {
                    return null;
                }
                for (Field field : fieldArrayList) {
                    if (!field.canAccess(object)) continue;
                    return JavetClassConverter.this.toV8Value(JavetClassConverter.this.v8Runtime, field.get(object));
                }
                return null;
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public V8Value set(Object object, V8Value name, V8Value value) {
            try {
                System.out.println("Object Setter call: " + object.getClass().getName() + "::" + name.asString() + "=" + value.asString());
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public <T> V8Value invokeExternal(T object, V8Value ... args) {
            try {
                switch (args[0].asString()) {
                    case "invoke": {
                        ArrayList<Method> methods = this.methodsFromName.get(args[1].asString());
                        List<V8Value> arguments = List.of(args);
                        V8Value[] passedArguments = arguments.subList(2, arguments.size()).toArray(new V8Value[0]);
                        return this.invoke(object, methods, passedArguments);
                    }
                    case "set": {
                        return this.set(object, args[1], args[2]);
                    }
                    case "get": {
                        return this.get(object, args[1]);
                    }
                }
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public static FunctionHandler createFunction(InvokeHandler invokeHandler, Object object) {
            return args -> invokeHandler.invokeExternal(object, args);
        }

        public static interface FunctionHandler {
            public V8Value execute(V8Value ... var1);
        }
    }
}

