/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.logging.JavetStandardConsoleInterceptor;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import kasuga.lib.core.addons.node.NodePackage;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.engine.JavascriptEngineContext;
import kasuga.lib.core.javascript.engine.JavascriptModuleScope;
import kasuga.lib.core.javascript.engine.JavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptModule;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetKasugaConverter;
import kasuga.lib.core.javascript.engine.javet.JavetModuleAPI;

public class JavetContext
implements JavascriptEngineContext {
    private final JavascriptContext context;
    V8Runtime runtime;
    JavetModuleAPI moduleAPI;

    JavetContext(JavascriptContext context) throws JavetException {
        this.context = context;
        this.runtime = V8Host.getV8Instance().createV8Runtime();
        JavetStandardConsoleInterceptor consoleInterceptor = new JavetStandardConsoleInterceptor(this.runtime);
        consoleInterceptor.register(this.runtime.getGlobalObject());
        this.moduleAPI = new JavetModuleAPI(this.runtime, this, context.getModuleLoader());
        this.runtime.setConverter(new JavetKasugaConverter(this.runtime));
        this.runtime.setPromiseRejectCallback((event, promise, value) -> {
            if (event.getCode() == 0) {
                System.err.println("Error" + event.getName());
            }
        });
    }

    @Override
    public void loadModule(String moduleName) {
        this.moduleAPI.getRequireFunction(null).execute(moduleName);
    }

    @Override
    public JavascriptValue asValue(Object object) {
        try {
            return new JavetJavascriptValue((V8Value)this.runtime.getConverter().toV8Value(this.runtime, object), this.runtime);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavascriptModuleScope getModuleScope() {
        return this.getContext().getModuleScope();
    }

    @Override
    public JavetJavascriptModule compileModuleFromSource(NodePackage packageTarget, String fileName, String dirName, InputStream stream) {
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read");
        }
        try {
            UUID uniqueId = UUID.randomUUID();
            String temporyModuleName = fileName;
            V8ValueFunction module = this.runtime.getExecutor(textBuilder.toString()).setResourceName(fileName).compileV8ValueFunction(new String[]{"require", "exports", "module"});
            return new JavetJavascriptModule(module, packageTarget, dirName, fileName, this.context);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavetJavascriptModule compileNativeModule(Object target, String moduleName) {
        try {
            Object module = this.runtime.getConverter().toV8Value(this.runtime, target);
            return new JavetJavascriptModule((V8Value)module, "native@" + moduleName);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavascriptContext getContext() {
        return this.context;
    }
}

