/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueNumber;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueReference;
import java.util.Objects;
import kasuga.lib.core.javascript.engine.JavascriptValue;

public class JavetJavascriptValue
implements JavascriptValue {
    private final V8Runtime runtime;
    public V8Value value;
    public V8Value reciever;

    public JavetJavascriptValue(V8Value v8Value, V8Runtime runtime) throws JavetException {
        this(v8Value, v8Value, runtime);
    }

    public JavetJavascriptValue(V8Value v8Value, V8Value reciever, V8Runtime runtime) {
        this.value = v8Value;
        this.runtime = runtime;
    }

    @Override
    public boolean isString() {
        return this.value instanceof V8ValueString;
    }

    @Override
    public String asString() {
        try {
            return this.value.asString();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T as(Class<T> className) {
        try {
            return this.runtime.getConverter().toObject(this.value);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean canExecute() {
        return this.value instanceof V8ValueFunction;
    }

    @Override
    public JavascriptValue execute(Object ... objects) {
        try {
            V8Value _reciever = this.reciever;
            if (_reciever == null) {
                _reciever = this.value;
            }
            return new JavetJavascriptValue((V8Value)((V8ValueFunction)this.value).call(this.reciever, objects), this.runtime);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeVoid(Object ... objects) {
        try {
            ((V8ValueFunction)this.value).callVoid(this.reciever, objects);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void pin() {
        V8Value v8Value = this.value;
        if (v8Value instanceof V8ValueReference) {
            V8ValueReference reference = (V8ValueReference)v8Value;
            try {
                reference.clearWeak();
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void unpin() {
        V8Value v8Value = this.value;
        if (v8Value instanceof V8ValueReference) {
            V8ValueReference reference = (V8ValueReference)v8Value;
            try {
                reference.setWeak();
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean hasMember(String memberName) {
        try {
            return ((V8ValueObject)this.value).has(memberName);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavascriptValue getMember(String memberName) {
        try {
            return new JavetJavascriptValue((V8Value)((V8ValueObject)this.value).get(memberName), this.value, this.runtime);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavascriptValue invokeMember(String memberName, Object ... objects) {
        return this.getMember(memberName).execute(objects);
    }

    @Override
    public boolean isNumber() {
        return this.value instanceof V8ValueNumber;
    }

    @Override
    public int asInt() {
        try {
            return this.value.asInt();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public V8Value getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavetJavascriptValue that = (JavetJavascriptValue)object;
        try {
            return (this.value == that.value || this.value.equals(that.value)) && Objects.equals(this.reciever, that.reciever);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.value, this.reciever);
    }
}

