/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.engine.javet;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import kasuga.lib.core.javascript.engine.javet.JavetClassConverter;
import kasuga.lib.core.javascript.engine.javet.JavetJavascriptValue;
import kasuga.lib.core.javascript.engine.javet.JavetValue;

public class JavetKasugaConverter
extends JavetObjectConverter {
    JavetClassConverter classConverter;
    private final V8Runtime runtime;
    private final V8ValueSymbol SYMBOL_NATIVE_OBJECT;
    HashMap<Integer, WeakReference<Object>> cachedObjects = new HashMap();

    JavetKasugaConverter(V8Runtime runtime) {
        this.runtime = runtime;
        try {
            this.SYMBOL_NATIVE_OBJECT = runtime.createV8ValueSymbol("NATIVE OBJECT");
            this.classConverter = new JavetClassConverter(runtime, this);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object, int depth) throws JavetException {
        if (object == null) {
            return (T)v8Runtime.createV8ValueNull();
        }
        if (object instanceof JavetJavascriptValue) {
            JavetJavascriptValue value = (JavetJavascriptValue)object;
            return value.getValue().toClone();
        }
        Object v8Value = super.toV8Value(v8Runtime, object, depth);
        if (v8Value != null && !v8Value.isUndefined()) {
            if (v8Value instanceof V8ValueObject) {
                V8ValueObject v8ValueObject = (V8ValueObject)v8Value;
                int hashCode = System.identityHashCode(object);
                v8ValueObject.setInteger(this.SYMBOL_NATIVE_OBJECT, hashCode);
                this.cachedObjects.put(hashCode, new WeakReference<Object>(object));
            }
            return v8Value;
        }
        V8Value v8ValueConverted = this.classConverter.toV8Value(this.runtime, object);
        if (v8ValueConverted != null && !v8ValueConverted.isUndefined()) {
            if (v8ValueConverted instanceof V8ValueObject) {
                V8ValueObject v8ValueObject = (V8ValueObject)v8ValueConverted;
                int hashCode = System.identityHashCode(object);
                v8ValueObject.setProperty(this.SYMBOL_NATIVE_OBJECT, hashCode);
                this.cachedObjects.put(hashCode, new WeakReference<Object>(object));
            }
            return (T)v8ValueConverted;
        }
        throw new IllegalStateException("Unknown converting");
    }

    @Override
    protected <T> T toObject(V8Value v8Value, int depth) throws JavetException {
        int address;
        V8ValueObject object;
        if (v8Value instanceof V8ValueObject && (object = (V8ValueObject)v8Value).has(this.SYMBOL_NATIVE_OBJECT) && this.cachedObjects.containsKey(address = object.getInteger(this.SYMBOL_NATIVE_OBJECT).intValue())) {
            Object nativeObject = this.cachedObjects.get(address).get();
            return nativeObject;
        }
        Object parentConvertResult = super.toObject(v8Value, depth);
        if (parentConvertResult instanceof V8Value) {
            return (T)new JavetJavascriptValue(JavetValue.weakClone(v8Value), v8Value.getV8Runtime());
        }
        return parentConvertResult;
    }
}

