/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import kasuga.lib.core.menu.BindingClient;
import kasuga.lib.core.menu.GuiBinding;
import kasuga.lib.core.menu.GuiMenuManager;
import kasuga.lib.core.menu.packet.C2SChannelClosedPacket;
import kasuga.lib.core.menu.packet.C2SChannelMessagePacket;
import kasuga.lib.core.menu.packet.C2SConnectMenuPacket;
import kasuga.lib.core.menu.packet.S2CChannelClosedPacket;
import kasuga.lib.core.menu.packet.S2CChannelMessagePacket;
import kasuga.lib.core.network.S2CPacket;
import kasuga.lib.core.packets.AllPackets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class GuiMenu {
    GuiBinding currentBinding;
    UUID uuid;
    HashSet<UUID> remotes = new HashSet();
    HashMap<UUID, ServerPlayer> remotePlayers = new HashMap();
    boolean isClient = false;

    public GuiMenu(Function<UUID, GuiBinding> bindingSupplier) {
        this(bindingSupplier, UUID.randomUUID());
    }

    public GuiMenu(Function<UUID, GuiBinding> bindingSupplier, UUID uuid) {
        this.uuid = uuid;
        this.currentBinding = bindingSupplier.apply(this.uuid);
    }

    public void createGuiInstance() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BindingClient.createInstance(this.uuid, this.currentBinding.sourceCodeLocation));
    }

    public void createConnection(UUID remoteId) {
        if (this.remotes.contains(remoteId) || this.uuid == remoteId) {
            return;
        }
        C2SConnectMenuPacket connectMenuPacket = new C2SConnectMenuPacket(this.uuid, remoteId);
        AllPackets.channel.sendToServer(connectMenuPacket);
    }

    public boolean addRemote(UUID remoteId, ServerPlayer player) {
        if (this.remotes.contains(remoteId)) {
            return false;
        }
        this.remotes.add(remoteId);
        this.remotePlayers.put(remoteId, player);
        return true;
    }

    public boolean addRemote(UUID remoteId) {
        if (this.remotes.contains(remoteId)) {
            return false;
        }
        this.remotes.add(remoteId);
        return true;
    }

    public UUID getID() {
        return this.uuid;
    }

    public GuiBinding getBinding() {
        return this.currentBinding;
    }

    public void removeConnecting(UUID remoteUUID) {
    }

    public void listen(boolean isClient) {
        if (isClient) {
            this.isClient = true;
            GuiMenuManager.listenFromClient(this);
        } else {
            this.isClient = false;
            GuiMenuManager.listenFromServer(this);
        }
    }

    public void unlisten(boolean isClient) {
        if (isClient) {
            GuiMenuManager.unlistenFromClient(this);
        } else {
            GuiMenuManager.unlistenFromServer(this);
        }
    }

    public void close() {
        this.remotes.forEach(remote -> this.close((UUID)remote));
    }

    public void close(UUID remote) {
        if (this.isClient) {
            AllPackets.channel.sendToServer(new C2SChannelClosedPacket(remote, this.uuid));
        } else {
            AllPackets.channel.sendToClient((S2CPacket)new S2CChannelClosedPacket(remote, this.uuid), this.remotePlayers.get(remote));
        }
    }

    public void onClose(UUID remoteId) {
        this.remotes.remove(remoteId);
        this.remotePlayers.remove(remoteId);
    }

    public void closeByPlayer(ServerPlayer player) {
        HashSet needToDelete = new HashSet();
        this.remotePlayers.forEach((i, j) -> {
            if (j == player) {
                needToDelete.add(i);
            }
        });
        for (UUID id : needToDelete) {
            this.remotePlayers.remove(id);
        }
    }

    public void onMessage(UUID fromUUID, CompoundTag data) {
    }

    public void send(CompoundTag data) {
        this.remotes.forEach(remote -> this.send((UUID)remote, data));
    }

    public void send(UUID remote, CompoundTag data) {
        if (this.isClient) {
            AllPackets.channel.sendToServer(new C2SChannelMessagePacket(this.uuid, remote, data));
        } else {
            AllPackets.channel.sendToClient((S2CPacket)new S2CChannelMessagePacket(this.uuid, remote, data), this.remotePlayers.get(remote));
        }
    }
}

