/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.packet;

import java.util.UUID;
import kasuga.lib.core.menu.GuiMenu;
import kasuga.lib.core.menu.GuiMenuManager;
import kasuga.lib.core.network.C2SPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class C2SChannelMessagePacket
extends C2SPacket {
    UUID fromUUID;
    UUID toUUID;
    CompoundTag data;

    public C2SChannelMessagePacket(UUID fromUUID, UUID toUUID, CompoundTag data) {
        this.fromUUID = fromUUID;
        this.toUUID = toUUID;
        this.data = data;
    }

    public C2SChannelMessagePacket(FriendlyByteBuf byteBuf) {
        this.fromUUID = byteBuf.m_130259_();
        this.toUUID = byteBuf.m_130259_();
        this.data = byteBuf.m_130260_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.fromUUID);
        buf.m_130077_(this.toUUID);
        buf.m_130079_(this.data);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            GuiMenu guiMenu = GuiMenuManager.findMenuFromServer(this.toUUID);
            if (guiMenu != null) {
                return;
            }
            guiMenu.onMessage(this.fromUUID, this.data);
        });
    }
}

