/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.menu.packet;

import java.util.UUID;
import kasuga.lib.core.menu.GuiMenu;
import kasuga.lib.core.menu.GuiMenuManager;
import kasuga.lib.core.menu.packet.S2CConeectMenuResponsePacket;
import kasuga.lib.core.network.C2SPacket;
import kasuga.lib.core.network.S2CPacket;
import kasuga.lib.core.packets.AllPackets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class C2SConnectMenuPacket
extends C2SPacket {
    UUID localUUID;
    UUID remoteUUID;

    public C2SConnectMenuPacket(UUID localUUID, UUID remoteUUID) {
        this.localUUID = localUUID;
        this.remoteUUID = remoteUUID;
    }

    public C2SConnectMenuPacket(FriendlyByteBuf byteBuf) {
        this.localUUID = byteBuf.m_130259_();
        this.remoteUUID = byteBuf.m_130259_();
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            GuiMenu menu = GuiMenuManager.findMenuFromServer(this.remoteUUID);
            boolean established = false;
            if (menu != null) {
                established = menu.addRemote(this.localUUID, context.getSender());
            }
            S2CConeectMenuResponsePacket response = new S2CConeectMenuResponsePacket(this.localUUID, this.remoteUUID, established);
            AllPackets.channel.sendToClient((S2CPacket)response, context.getSender());
        });
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.localUUID);
        buf.m_130077_(this.remoteUUID);
    }
}

