/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.xml;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.annos.Util;
import kasuga.lib.core.xml.IXmlObject;
import kasuga.lib.core.xml.XmlCompound;
import kasuga.lib.core.xml.XmlNumber;
import kasuga.lib.core.xml.XmlString;

@Util
public class JsonConvertor {
    @Util
    public static IXmlObject<?> json2Xml(String key, JsonElement jsonObject) {
        if (jsonObject.isJsonPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)jsonObject;
            if (primitive.isNumber()) {
                return new XmlNumber(key, (Double)primitive.getAsDouble(), new IXmlObject[0]);
            }
            return new XmlString(key, primitive.getAsString(), new IXmlObject[0]);
        }
        if (jsonObject.isJsonObject()) {
            XmlCompound compound;
            JsonObject obj = (JsonObject)jsonObject;
            if (obj.has("attr")) {
                JsonElement element;
                JsonObject object = obj.getAsJsonObject("attr");
                Set entries = object.entrySet();
                IXmlObject[] objs = new IXmlObject[entries.size()];
                int counter = 0;
                for (Map.Entry entry : entries) {
                    objs[counter] = JsonConvertor.json2Xml((String)entry.getKey(), (JsonElement)entry.getValue());
                    ++counter;
                }
                if (obj.entrySet().size() == 2 && obj.has("value") && (element = obj.get("value")).isJsonPrimitive()) {
                    JsonPrimitive pri = element.getAsJsonPrimitive();
                    if (pri.isNumber()) {
                        return new XmlNumber(key, (Double)pri.getAsDouble(), objs);
                    }
                    return new XmlString(key, pri.getAsString(), objs);
                }
                compound = new XmlCompound(key, objs);
            } else {
                compound = new XmlCompound(key, new IXmlObject[0]);
            }
            for (Map.Entry entry : obj.entrySet()) {
                compound.setValue(key, JsonConvertor.json2Xml((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
            return compound;
        }
        return null;
    }

    @Util
    public static JsonElement xml2Json(IXmlObject<?> xmlObject) {
        if (xmlObject.isPrimitive()) {
            JsonPrimitive pri;
            Set<IXmlObject<?>> attr = xmlObject.attributes();
            boolean flag = attr.isEmpty();
            if (xmlObject instanceof XmlNumber) {
                XmlNumber number = (XmlNumber)xmlObject;
                pri = new JsonPrimitive((Number)number.getValue(number.key()));
            } else {
                pri = new JsonPrimitive(((XmlString)xmlObject).getValue(xmlObject.key()));
            }
            if (flag) {
                return pri;
            }
            JsonObject obj = new JsonObject();
            obj.add("value", (JsonElement)pri);
            JsonObject attributes = new JsonObject();
            for (IXmlObject<?> xml : attr) {
                attributes.add(xml.key(), JsonConvertor.xml2Json(xml));
            }
            obj.add("attr", (JsonElement)attributes);
            return obj;
        }
        JsonObject object = new JsonObject();
        XmlCompound compound = (XmlCompound)xmlObject;
        Set<IXmlObject<?>> attr = compound.attributes();
        Set<IXmlObject<?>> vals = compound.getValues();
        JsonObject attributes = new JsonObject();
        for (IXmlObject<?> xml : attr) {
            attributes.add(xml.key(), JsonConvertor.xml2Json(xml));
        }
        object.add("attr", (JsonElement)attributes);
        for (IXmlObject<?> xml : vals) {
            object.add(xml.key(), JsonConvertor.xml2Json(xml));
        }
        return object;
    }
}

