/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kasuga.lib.core.xml.IXmlObject;
import kasuga.lib.core.xml.XmlString;

public class XmlCompound
implements IXmlObject<IXmlObject<?>> {
    private String key = "";
    private final Set<IXmlObject<?>> values;
    private final Set<IXmlObject<?>> attributes;
    private boolean singleSide = false;

    public XmlCompound(String key, IXmlObject<?> ... attributes) {
        this.key = key;
        this.values = new HashSet();
        this.attributes = new HashSet();
        this.attributes.addAll(List.of(attributes));
    }

    public XmlCompound(String key, boolean singleSide, IXmlObject<?> ... attributes) {
        this.key = key;
        this.values = new HashSet();
        this.attributes = new HashSet();
        this.attributes.addAll(List.of(attributes));
        this.singleSide = singleSide;
    }

    public static XmlCompound empty() {
        return new XmlCompound("", new IXmlObject[0]);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Set<IXmlObject<?>> getValues() {
        return this.values;
    }

    @Override
    public IXmlObject<?> getValue(String key) {
        return null;
    }

    @Override
    public void setValue(String key, Object value) {
        if (!(value instanceof IXmlObject)) {
            return;
        }
        this.values.add((IXmlObject)value);
    }

    @Override
    public Set<IXmlObject<?>> attributes() {
        return this.attributes;
    }

    @Override
    public IXmlObject<?> getAttribute(String key) {
        Optional<IXmlObject> optional = this.attributes.stream().filter(a -> a.key().equals(key)).findAny();
        return optional.orElse(null);
    }

    @Override
    public void setAttribute(String key, Object value) {
        IXmlObject<?> attr = this.getAttribute(key);
        if (attr != null) {
            attr.setValue(key, value);
        }
    }

    @Override
    public String toFormattedString(int stage, boolean isPlainText) {
        String repeat = "    ".repeat(isPlainText ? 0 : Math.max(0, stage));
        StringBuilder builder = new StringBuilder(repeat + "<" + this.key);
        for (IXmlObject<?> attr : this.attributes) {
            builder.append(" ").append(attr.key()).append("=");
            if (attr instanceof XmlString) {
                builder.append("\"").append(attr.getValue(attr.key()).toString()).append("\"");
                continue;
            }
            builder.append(attr.getValue(attr.key()).toString());
        }
        builder.append(">\n");
        for (IXmlObject<?> value : this.values) {
            builder.append(value.toFormattedString(stage + 1, isPlainText));
        }
        builder.append(repeat);
        builder.append("</").append(this.key).append(">\n");
        return builder.toString();
    }

    @Override
    public boolean isSingleSideElement() {
        return this.singleSide;
    }

    @Override
    public void setIsSingleSide(boolean singleSide) {
        this.singleSide = singleSide;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        return this.toFormattedString(0, false);
    }
}

