/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.xml;

import java.util.Optional;
import java.util.Set;
import kasuga.lib.core.xml.IXmlObject;
import kasuga.lib.core.xml.XmlString;

public class XmlNumber
implements IXmlObject<Double> {
    private String key = "";
    private double value = 0.0;
    private final Set<IXmlObject<?>> attributes;
    private boolean singleSide = false;

    public XmlNumber(String key, Double value, IXmlObject<?> ... attributes) {
        this.key = key;
        this.value = value;
        this.attributes = Set.of(attributes);
    }

    public XmlNumber(String key, Double value, boolean singleSide, IXmlObject<?> ... attributes) {
        this.key = key;
        this.value = value;
        this.attributes = Set.of(attributes);
        this.singleSide = singleSide;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Set<Double> getValues() {
        return Set.of(Double.valueOf(this.value));
    }

    @Override
    public Double getValue(String key) {
        return this.key.equals(key) ? this.value : 0.0;
    }

    @Override
    public void setValue(String key, Object value) {
        if (!(value instanceof Double)) {
            return;
        }
        if (this.key.equals(key)) {
            this.value = (Double)value;
        }
    }

    @Override
    public Set<IXmlObject<?>> attributes() {
        return this.attributes;
    }

    @Override
    public IXmlObject<?> getAttribute(String key) {
        Optional<IXmlObject> optional = this.attributes.stream().filter(a -> a.key().equals(key)).findAny();
        return optional.orElse(null);
    }

    @Override
    public void setAttribute(String key, Object value) {
        IXmlObject<?> attr = this.getAttribute(key);
        if (attr != null) {
            attr.setValue(key, value);
        }
    }

    @Override
    public String toFormattedString(int stage, boolean isPlainText) {
        String repeat = "    ".repeat(isPlainText ? 0 : Math.max(0, stage));
        StringBuilder builder = new StringBuilder(repeat + "<" + this.key);
        for (IXmlObject<?> attr : this.attributes) {
            builder.append(" ").append(attr.key()).append("=");
            if (attr instanceof XmlString) {
                builder.append("\"").append(attr.getValue(attr.key()).toString()).append("\"");
                continue;
            }
            builder.append(attr.getValue(attr.key()).toString());
        }
        builder.append(this.singleSide ? "/>\n" : ">");
        if (!this.singleSide) {
            builder.append(this.value).append("</").append(this.key).append(">\n");
        }
        return builder.toString();
    }

    @Override
    public boolean isSingleSideElement() {
        return this.singleSide;
    }

    @Override
    public void setIsSingleSide(boolean singleSide) {
        this.singleSide = singleSide;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.toFormattedString(0, false);
    }
}

