/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.block.bogey.cw2;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.foundation.utility.Iterate;
import kasuga.lib.example_env.AllExampleElements;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class CW2BogeyRenderer
extends BogeyRenderer {
    public static final PartialModel CW2_FRAME = new PartialModel(CW2BogeyRenderer.asBlockModelResource("bogey/cw2/bogey_cw2_temple"));
    public static final PartialModel CW2_WHEEL = new PartialModel(CW2BogeyRenderer.asBlockModelResource("bogey/cw2/cw2_wheel"));

    private static ResourceLocation asBlockModelResource(String path) {
        return AllExampleElements.testRegistry.asResource("block/" + path);
    }

    public void initialiseContraptionModelData(MaterialManager materialManager, CarriageBogey carriageBogey) {
        this.createModelInstance(materialManager, new PartialModel[]{CW2_FRAME});
        this.createModelInstance(materialManager, CW2_WHEEL, 2);
    }

    public BogeySizes.BogeySize getSize() {
        return BogeySizes.SMALL;
    }

    public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
        boolean inInstancedContraption = vb == null;
        BogeyRenderer.BogeyModelData frame = this.getTransform(CW2_FRAME, ms, inInstancedContraption);
        frame.render(ms, light, vb);
        BogeyRenderer.BogeyModelData[] wheels = this.getTransform(CW2_WHEEL, ms, inInstancedContraption, 2);
        for (int side : Iterate.positiveAndNegative) {
            if (!inInstancedContraption) {
                ms.m_85836_();
            }
            BogeyRenderer.BogeyModelData wheel = wheels[(side + 1) / 2];
            wheel.translate(0.0, 0.805, (double)side * 1.2).rotateX((double)wheelAngle);
            wheel.render(ms, light, vb);
            if (inInstancedContraption) continue;
            ms.m_85849_();
        }
    }
}

