/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.block.bogey.pk209p;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import kasuga.lib.example_env.AllExampleBogey;
import kasuga.lib.example_env.ExampleTrackMaterial;
import kasuga.lib.example_env.block.bogey.pk209p.StandardBogeyBlockEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StandardBogeyBlock
extends AbstractBogeyBlock<StandardBogeyBlockEntity>
implements IBE<StandardBogeyBlockEntity>,
ProperWaterloggedBlock,
ISpecialBlockItemRequirement {
    private final List<Property<?>> properties_to_copy = ImmutableList.builder().addAll((Iterable)super.propertiesToCopy()).build();

    public StandardBogeyBlock(BlockBehaviour.Properties props, BogeySizes.BogeySize size) {
        super(props, size);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return ExampleTrackMaterial.exampleMaterial.getTrackType();
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public double getWheelPointSpacing() {
        return 2.5;
    }

    public double getWheelRadius() {
        return 0.915;
    }

    public Vec3 getConnectorAnchorOffset() {
        return new Vec3(0.0, 0.21875, 1.0);
    }

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public BogeyStyle getDefaultStyle() {
        return AllExampleBogey.standardGroup.getStyle();
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return AllBlocks.RAILWAY_CASING.asStack();
    }

    public Class<StandardBogeyBlockEntity> getBlockEntityClass() {
        return StandardBogeyBlockEntity.class;
    }

    public BlockEntityType<? extends StandardBogeyBlockEntity> getBlockEntityType() {
        return AllExampleBogey.standardBogeyEntity.getType();
    }

    public BlockState getRotatedBlockState(BlockState state, Direction targetedFace) {
        return state;
    }

    public List<Property<?>> propertiesToCopy() {
        return this.properties_to_copy;
    }

    public Set<TrackMaterial.TrackType> getValidPathfindingTypes(BogeyStyle style) {
        return Set.of(this.getTrackType(style), ExampleTrackMaterial.tielessMaterial.getTrackType());
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        TrackEdge currentEdge = point.edge;
        if (currentEdge == null) {
            return false;
        }
        return !this.getValidPathfindingTypes(bogey.getStyle()).contains(currentEdge.getTrackMaterial().trackType);
    }
}

