/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.block.gui;

import java.util.UUID;
import kasuga.lib.core.menu.GuiBinding;
import kasuga.lib.core.menu.GuiMenuUtils;
import kasuga.lib.core.menu.JavascriptGuiMenu;
import kasuga.lib.core.menu.targets.WorldRendererTarget;
import kasuga.lib.example_env.AllExampleElements;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class GuiExampleBlockEntity
extends BlockEntity {
    JavascriptGuiMenu menuEntry = new JavascriptGuiMenu(uuid -> GuiBinding.create(uuid).execute(new ResourceLocation("kasuga_lib", "example")));
    UUID serverId;
    int clickCount = 0;
    public int i = 0;

    public GuiExampleBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(AllExampleElements.guiExampleTile.getType(), pPos, pBlockState);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        this.initMenu(pLevel);
    }

    private void initMenu(Level pLevel) {
        if (pLevel.f_46443_) {
            this.menuEntry.createGuiInstance();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WorldRendererTarget.attach(this.menuEntry));
            if (!this.menuEntry.hasRemote() && this.serverId != null) {
                this.menuEntry.createConnection(this.serverId);
            }
        }
        this.menuEntry.listen(pLevel.f_46443_);
    }

    private void disposeMenu() {
        if (this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WorldRendererTarget.detach(this.menuEntry));
        }
        this.menuEntry.close();
        this.menuEntry.unlisten(this.f_58857_.f_46443_);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128362_("KasugaMenuEntryId", this.menuEntry.getID());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128403_("KasugaMenuEntryId")) {
            this.serverId = tag.m_128342_("KasugaMenuEntryId");
            this.menuEntry.createConnection(this.serverId);
        }
    }

    public void incrementData() {
        CompoundTag syncData = new CompoundTag();
        syncData.m_128405_("click", ++this.clickCount);
        this.menuEntry.send(syncData);
    }

    public void openScreen() {
        GuiMenuUtils.openScreen(this.menuEntry);
    }

    public void m_7651_() {
        super.m_7651_();
        this.disposeMenu();
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BlockEntity block) {
        GuiExampleBlockEntity entity = (GuiExampleBlockEntity)level.m_7702_(blockPos);
        entity.incrementData();
    }
}

