/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.base.item_helper.ExternalProperties;
import kasuga.lib.registrations.common.FluidReg;
import kasuga.lib.registrations.common.ItemReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class BucketItemReg<T extends BucketItem>
extends ItemReg<T> {
    @Nullable
    public ResourceLocation model;
    private boolean customRender = false;
    private BucketBuilder<T> builder;
    public final Item.Properties properties = new ExternalProperties();
    private RegistryObject<T> registryObject = null;
    private MenuReg<?, ?> menuReg = null;
    private Supplier<? extends ForgeFlowingFluid> fluid = null;
    private final List<TagKey<?>> tags;

    public BucketItemReg(String registrationKey, @Nullable ResourceLocation model) {
        super(registrationKey);
        this.model = model;
        this.tags = new ArrayList();
    }

    public BucketItemReg(String registrationKey) {
        super(registrationKey);
        this.model = null;
        this.tags = new ArrayList();
    }

    public static BucketItemReg<BucketItem> defaultBucketItem(FluidReg<?> fluidReg, @Nullable ResourceLocation model) {
        BucketItemReg<BucketItem> reg = new BucketItemReg<BucketItem>(fluidReg.registrationKey, model);
        reg.itemType(BucketItem::new);
        reg.fluidType(fluidReg::stillFluid);
        return reg;
    }

    public static BucketItemReg<BucketItem> defaultBucketItem(FluidReg<?> fluidReg) {
        BucketItemReg<BucketItem> reg = new BucketItemReg<BucketItem>(fluidReg.registrationKey);
        reg.itemType(BucketItem::new);
        reg.fluidType(fluidReg::stillFluid);
        return reg;
    }

    @Mandatory
    public BucketItemReg<T> fluidType(Supplier<? extends ForgeFlowingFluid> fluid) {
        this.fluid = fluid;
        return this;
    }

    @Mandatory
    public BucketItemReg<T> itemType(BucketBuilder<? extends Item> builder) {
        this.builder = builder;
        return this;
    }

    @Override
    public BucketItemReg<T> submit(SimpleRegistry registry) {
        if (this.model != null) {
            registry.modelMappings().addMapping(new ResourceLocation(registry.namespace, "item/" + this.registrationKey + ".json"), this.model);
        }
        if (this.customRender) {
            registry.stackCustomRenderedItemIn(this.registrationKey);
        }
        this.registryObject = registry.item().register(this.registrationKey, () -> this.builder.build(this.fluid, this.properties));
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        return this;
    }

    @Override
    public String getIdentifier() {
        return "bucket_item";
    }

    @Override
    ItemReg.ItemBuilder<T> type() {
        throw new UnsupportedOperationException("Could not call \"type()\" in this registry, please call \"bucketType()\" instead.");
    }

    BucketBuilder<T> bucketType() {
        return this.builder;
    }

    public static interface BucketBuilder<T extends BucketItem> {
        public T build(Supplier<? extends ForgeFlowingFluid> var1, Item.Properties var2);
    }
}

