/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.EntityRendererBuilder;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class EntityReg<T extends Entity>
extends Reg {
    EntityBuilder<T> builder;
    RegistryObject<EntityType<T>> registryObject;
    MobCategory mobCategory;
    public final List<Object> externalArgs = new ArrayList<Object>();
    private EntityAttributeBuilder attributeBuilder;
    private Supplier<EntityRendererBuilder<T>> provider = null;
    private EntityPropertyIdentifier<T> identifier;
    public float height = 1.0f;
    public float width = 1.0f;

    public EntityReg(String registrationKey) {
        super(registrationKey);
    }

    @Mandatory
    public EntityReg<T> entityType(EntityBuilder<T> builder) {
        this.builder = builder;
        return this;
    }

    @Mandatory
    public EntityReg<T> withRenderer(Supplier<EntityRendererBuilder<T>> provider) {
        this.provider = provider;
        return this;
    }

    @Mandatory
    public EntityReg<T> attribute(EntityAttributeBuilder builder) {
        this.attributeBuilder = builder;
        return this;
    }

    @Optional
    public EntityReg<T> size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Optional
    public EntityReg<T> addProperty(EntityPropertyIdentifier<? extends Entity> identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    @Mandatory
    public EntityReg<T> submit(SimpleRegistry registry) {
        if (this.builder == null) {
            this.crashOnNotPresent(EntityBuilder.class, "entityType", "submit");
        }
        EntityType.Builder tBuilder = EntityType.Builder.m_20704_(this.builder::build, (MobCategory)this.mobCategory);
        if (this.identifier != null) {
            this.identifier.apply(tBuilder);
        }
        this.registryObject = registry.entity().register(this.registrationKey, () -> tBuilder.m_20699_(this.width, this.height).m_20712_(this.registrationKey));
        if (this.provider != null) {
            registry.cacheEntityIn(this);
        }
        if (this.attributeBuilder != null) {
            registry.cacheLivingEntityIn(this);
        }
        return this;
    }

    public AttributeSupplier.Builder getAttributeSupplier() {
        return this.attributeBuilder.get();
    }

    @Override
    public String getIdentifier() {
        return "entity";
    }

    public EntityType<T> getType() {
        return this.registryObject == null ? null : (EntityType)this.registryObject.get();
    }

    @Inner
    public void registerRenderer() {
        EntityRenderers.m_174036_((EntityType)((EntityType)this.registryObject.get()), this.provider.get()::build);
    }

    public static interface EntityBuilder<T extends Entity> {
        public T build(EntityType<T> var1, Level var2);
    }

    public static interface EntityAttributeBuilder {
        public AttributeSupplier.Builder get();
    }

    public static interface EntityPropertyIdentifier<T extends Entity> {
        public void apply(EntityType.Builder<T> var1);
    }
}

