/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.create;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import java.util.function.Predicate;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.create.InteractionMovementReg;
import kasuga.lib.registrations.create.InteractionReg;
import kasuga.lib.registrations.registry.CreateRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;

public class MovementReg<T extends MovementBehaviour>
extends Reg
implements InteractionMovementReg {
    private TagKey[] tags = null;
    private BlockReg[] blocks = null;
    private InteractionReg.InteractionPredicate predicate = null;
    private Predicate<BlockReg> blockPredicate = null;
    private Predicate<BlockState> statePredicate = null;
    private MovementBehaviour behaviour = null;
    private InteractionReg.WorkType workType = InteractionReg.WorkType.blocks;

    public MovementReg(String registrationKey) {
        super(registrationKey);
    }

    public MovementReg<T> behaviour(T behaviour) {
        this.behaviour = behaviour;
        return this;
    }

    public MovementReg<T> sortByTags(TagKey ... keys) {
        this.tags = keys;
        this.workType = InteractionReg.WorkType.tag;
        return this;
    }

    public MovementReg<T> sortByBlocks(BlockReg ... blocks) {
        this.blocks = blocks;
        this.workType = InteractionReg.WorkType.blocks;
        return this;
    }

    public MovementReg<T> mixedPredicate(InteractionReg.InteractionPredicate predicate) {
        this.predicate = predicate;
        this.workType = InteractionReg.WorkType.mixed_predicate;
        return this;
    }

    public MovementReg<T> blockPredicate(Predicate<BlockReg> predicate) {
        this.blockPredicate = predicate;
        this.workType = InteractionReg.WorkType.predicate;
        return this;
    }

    public MovementReg<T> statePredicate(Predicate<BlockState> predicate) {
        this.statePredicate = predicate;
        this.workType = InteractionReg.WorkType.state_predicate;
        return this;
    }

    @Override
    public MovementReg<T> submit(SimpleRegistry registry) {
        if (!(registry instanceof CreateRegistry)) {
            this.crashOnNotPresent(InteractionReg.class, this.getIdentifier(), "Use CreateRegistry instead of SimpleRegistry");
        }
        ((CreateRegistry)registry).cacheMovementIn(this);
        return this;
    }

    @Override
    public void onSetup() {
        if (this.behaviour == null) {
            this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a type of interaction for registration");
        }
        switch (this.workType) {
            case blocks: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                for (BlockReg block : this.blocks) {
                    AllMovementBehaviours.registerBehaviour(block.getBlock(), (MovementBehaviour)this.behaviour);
                }
                break;
            }
            case predicate: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                if (this.blockPredicate == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a predictor for registration.");
                }
                for (BlockReg block : this.blocks) {
                    if (!this.blockPredicate.test(block)) continue;
                    AllMovementBehaviours.registerBehaviour(block.getBlock(), (MovementBehaviour)this.behaviour);
                }
                break;
            }
            case state_predicate: {
                if (this.statePredicate == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a predictor for registration.");
                }
                AllMovementBehaviours.registerBehaviourProvider(state -> this.statePredicate.test(state) ? this.behaviour : null);
                break;
            }
            case tag: {
                if (this.tags == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a list of tags for registration.");
                }
                AllMovementBehaviours.registerBehaviourProvider(state -> {
                    boolean flag = false;
                    for (TagKey tag : this.tags) {
                        if (!state.m_204336_(tag)) continue;
                        flag = true;
                        break;
                    }
                    return flag ? this.behaviour : null;
                });
                break;
            }
            case mixed_predicate: {
                if (this.blocks == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a list of block for registration.");
                }
                if (this.tags == null) {
                    this.crashOnNotPresent(MovementReg.class, this.getIdentifier(), "you must provide a list of tags for registration.");
                }
                for (BlockReg reg : this.blocks) {
                    boolean flag = false;
                    for (TagKey tag : this.tags) {
                        if (!this.predicate.test(reg, tag)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    AllMovementBehaviours.registerBehaviour(reg.getBlock(), (MovementBehaviour)this.behaviour);
                }
                break;
            }
        }
    }

    @Override
    public String getIdentifier() {
        return "movement_behaviour";
    }
}

