/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.registry;

import java.util.HashMap;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.registrations.client.ModelReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;

@Inner
public class ModelRegistry {
    public final String namespace;
    public final HashMap<ResourceLocation, ModelReg> UNBAKED;
    public final HashMap<ResourceLocation, BakedModel> BAKED;
    public final SimpleRegistry registry;

    public ModelRegistry(String namespace, SimpleRegistry registry) {
        this.namespace = namespace;
        this.UNBAKED = new HashMap();
        this.BAKED = new HashMap();
        this.registry = registry;
    }

    public void register(ModelReg reg) {
        this.UNBAKED.put(reg.location(), reg);
    }

    @Inner
    public void putBakedIn(ResourceLocation location, BakedModel model) {
        this.BAKED.put(location, model);
    }

    @Inner
    public HashMap<ResourceLocation, ModelReg> getUnbaked() {
        return this.UNBAKED;
    }

    @Inner
    public void clearUnbaked() {
        this.UNBAKED.clear();
    }

    public BakedModel getModel(ResourceLocation location) {
        return this.BAKED.getOrDefault(location, null);
    }

    public HashMap<ResourceLocation, BakedModel> getBaked() {
        return this.BAKED;
    }
}

