/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data;

import java.util.HashMap;
import java.util.Set;
import kasuga.lib.vendor_modules.interpreter.compute.data.Line;
import kasuga.lib.vendor_modules.interpreter.compute.data.Variable;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.DoublePrarmFunction;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.Function;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.SingleParamFunction;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.TripleParamFunction;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Assignable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.logic.data.LogicalLine;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;

public class Namespace {
    public final HashMap<String, Function> FUNCTIONS = new HashMap();
    public final HashMap<String, Variable> STATIC_VARS = new HashMap();
    public final HashMap<String, Assignable> INSTANT_VARS = new HashMap();
    private Namespace parent;

    public Namespace() {
        this(null);
    }

    public Namespace(Namespace parent) {
        if (parent != null) {
            this.parent = parent;
            this.FUNCTIONS.putAll(parent.FUNCTIONS);
            this.STATIC_VARS.putAll(parent.STATIC_VARS);
            this.INSTANT_VARS.putAll(parent.INSTANT_VARS);
        }
    }

    public Namespace parent() {
        return this.parent;
    }

    public HashMap<String, Function> functions() {
        return this.FUNCTIONS;
    }

    public HashMap<String, Assignable> variables() {
        HashMap<String, Assignable> vars = new HashMap<String, Assignable>();
        vars.putAll(this.STATIC_VARS);
        vars.putAll(this.INSTANT_VARS);
        return vars;
    }

    public <T extends Function> T register(String codec, T function) {
        this.FUNCTIONS.put(codec, function);
        return function;
    }

    public SingleParamFunction register1Param(String codec, SingleParamFunction.Computer computer) {
        SingleParamFunction function = new SingleParamFunction(codec, this, computer);
        this.FUNCTIONS.put(codec, function);
        return function;
    }

    public DoublePrarmFunction register2Param(String codec, DoublePrarmFunction.Computer computer) {
        DoublePrarmFunction function = new DoublePrarmFunction(codec, this, computer);
        this.FUNCTIONS.put(codec, function);
        return function;
    }

    public TripleParamFunction register3Param(String codec, TripleParamFunction.Computer computer) {
        TripleParamFunction function = new TripleParamFunction(codec, this, computer);
        this.FUNCTIONS.put(codec, function);
        return function;
    }

    public Function createFunctionInstance(String codec) {
        if (this.FUNCTIONS.containsKey(codec)) {
            return this.FUNCTIONS.get(codec).clone(this);
        }
        return null;
    }

    public Variable register(String codec, float value) {
        Variable variable = new Variable(codec, this, value);
        this.STATIC_VARS.put(codec, variable);
        return variable;
    }

    public void registerInstance(String codec, Assignable assignable) {
        this.INSTANT_VARS.put(codec, assignable);
    }

    public boolean hasInstance() {
        return !this.INSTANT_VARS.isEmpty();
    }

    public void assign(String codec, float value) {
        if (this.INSTANT_VARS.containsKey(codec)) {
            this.INSTANT_VARS.get(codec).assign(codec, value);
        }
    }

    public Formula decodeFormula(String formulaString) {
        Line line;
        Formula formula = line = new Line(formulaString, this);
        while (formula instanceof Line && formula.getElements().size() == 1) {
            formula = formula.getElements().get(0);
        }
        return formula;
    }

    public LogicalData decodeLogical(String logicalString) {
        LogicalLine line;
        LogicalData data = new LogicalLine(logicalString, this);
        while (data instanceof LogicalLine && !(line = data).isEmpty() && line.isAtomic()) {
            data = line.getFirst();
        }
        return data;
    }

    public int instanceVarSize() {
        return this.INSTANT_VARS.size();
    }

    public boolean containsInstance(String codec) {
        return this.INSTANT_VARS.containsKey(codec);
    }

    public Assignable getInstance(String codec) {
        return this.INSTANT_VARS.getOrDefault(codec, null);
    }

    public Set<String> instanceNames() {
        return this.INSTANT_VARS.keySet();
    }

    public Variable getStaticVar(String codec) {
        return this.STATIC_VARS.getOrDefault(codec, null);
    }

    public Function getFunction(String codec) {
        return this.FUNCTIONS.getOrDefault(codec, null);
    }

    public Namespace clone() {
        Namespace namespace = new Namespace(this);
        namespace.parent = this.parent;
        return namespace;
    }
}

