/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data;

import java.util.List;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaSynatxError;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;

public class Numeric
implements Formula {
    private float number = 0.0f;
    private boolean flip = false;

    public Numeric(float number) {
        this.number = number;
    }

    public Numeric(String string) {
        this.number = Float.parseFloat(string);
    }

    @Override
    public String getString() {
        return (this.flip ? "-" : "") + this.number;
    }

    @Override
    public String getIdentifier() {
        return "numeric";
    }

    @Override
    public float getResult() {
        return this.flip ? -this.number : this.number;
    }

    @Override
    public List<Formula> getElements() {
        return List.of(this);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean shouldRemove() {
        return false;
    }

    @Override
    public void fromString(String string) {
        try {
            this.number = Float.parseFloat(string);
        }
        catch (Exception e) {
            throw new FormulaSynatxError(this, 0);
        }
    }

    public static boolean isNumber(String string) {
        return string.replaceAll(" ", "").replaceAll("^\\d+(\\.\\d+)?$", "").equals("");
    }

    @Override
    public Numeric clone() {
        return new Numeric(String.valueOf(this.number));
    }

    @Override
    public void flipOutput(boolean flip) {
        this.flip = flip;
    }

    @Override
    public boolean isOutputFlipped() {
        return this.flip;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Numeric)) {
            return false;
        }
        Numeric numeric = (Numeric)obj;
        return numeric.number == this.number;
    }
}

