/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGSize
extends Struct<YGSize>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected YGSize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected YGSize create(long address, @Nullable ByteBuffer container) {
        return new YGSize(address, container);
    }

    public YGSize(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGSize.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float width() {
        return YGSize.nwidth(this.address());
    }

    public float height() {
        return YGSize.nheight(this.address());
    }

    public YGSize width(float value) {
        YGSize.nwidth(this.address(), value);
        return this;
    }

    public YGSize height(float value) {
        YGSize.nheight(this.address(), value);
        return this;
    }

    public YGSize set(float width, float height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public YGSize set(YGSize src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGSize malloc() {
        return new YGSize(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static YGSize calloc() {
        return new YGSize(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static YGSize create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new YGSize(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static YGSize create(long address) {
        return new YGSize(address, null);
    }

    @Nullable
    public static YGSize createSafe(long address) {
        return address == 0L ? null : new YGSize(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)YGSize.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGSize.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static YGSize mallocStack() {
        return YGSize.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGSize callocStack() {
        return YGSize.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGSize mallocStack(MemoryStack stack) {
        return YGSize.malloc(stack);
    }

    @Deprecated
    public static YGSize callocStack(MemoryStack stack) {
        return YGSize.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return YGSize.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return YGSize.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGSize.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGSize.calloc(capacity, stack);
    }

    public static YGSize malloc(MemoryStack stack) {
        return new YGSize(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static YGSize calloc(MemoryStack stack) {
        return new YGSize(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nwidth(long struct) {
        return UNSAFE.getFloat(null, struct + (long)WIDTH);
    }

    public static float nheight(long struct) {
        return UNSAFE.getFloat(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = YGSize.__struct((Struct.Member[])new Struct.Member[]{YGSize.__member((int)4), YGSize.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGSize, Buffer>
    implements NativeResource {
        private static final YGSize ELEMENT_FACTORY = YGSize.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGSize getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float width() {
            return YGSize.nwidth(this.address());
        }

        public float height() {
            return YGSize.nheight(this.address());
        }

        public Buffer width(float value) {
            YGSize.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            YGSize.nheight(this.address(), value);
            return this;
        }
    }
}

