/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.bones;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.animation.data.bones.BoneMovement;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BonesGroup {
    private final HashMap<String, BoneMovement> movements = new HashMap();
    private final Namespace namespace;
    private final Animation animation;

    public BonesGroup(Animation animation, Namespace namespace) {
        this.animation = animation;
        this.namespace = namespace;
    }

    public void decodeBones(JsonObject bones) {
        Set entries = bones.entrySet();
        for (Map.Entry entry : entries) {
            Object v = entry.getValue();
            if (!(v instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)v;
            this.movements.put((String)entry.getKey(), BoneMovement.decode((String)entry.getKey(), this.namespace, this.animation, jsonObject));
        }
    }

    public void init() {
        this.movements.values().forEach(BoneMovement::invoke);
        this.movements.values().forEach(BoneMovement::init);
    }

    @Nullable
    public BoneMovement getMovement(String key) {
        return this.movements.getOrDefault(key, null);
    }

    public HashMap<String, BoneMovement> getMovements() {
        return this.movements;
    }

    public int movementCount() {
        return this.movements.size();
    }

    public boolean containsMovements(String key) {
        return this.movements.containsKey(key);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void action(String boneName, PoseStack stack) {
        if (!this.containsMovements(boneName)) {
            return;
        }
        this.getMovement(boneName).action(stack);
    }

    public boolean shouldRender(String boneName) {
        if (!this.containsMovements(boneName)) {
            return false;
        }
        return this.getMovement(boneName).shouldDisplay();
    }
}

