/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.base;

import java.util.List;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.world.phys.Vec3;

public interface IBezier {
    public List<Vec3> getBezierPoints();

    public Vec3 getMovementVector();

    public void createDefaultBezier(IBezier var1);

    default public void addBezierPoint(Vec3 point) {
        this.getBezierPoints().add(point);
    }

    default public void addBezierPoint(int index, Vec3 point) {
        this.getBezierPoints().add(point);
    }

    default public int bezierPointCount() {
        return this.getBezierPoints().size();
    }

    default public boolean hasBezierPoints() {
        return !this.getBezierPoints().isEmpty();
    }

    default public Pair<Vec3, Vec3> firstAndLast() {
        if (this.getBezierPoints().isEmpty()) {
            return Pair.of(Vec3.f_82478_, Vec3.f_82478_);
        }
        if (this.getBezierPoints().size() == 1) {
            return Pair.of(this.getBezierPoints().get(0), this.getBezierPoints().get(0));
        }
        return Pair.of(this.getBezierPoints().get(0), this.getBezierPoints().get(this.bezierPointCount() - 1));
    }

    default public Vec3 beginDirection() {
        if (!this.hasBezierPoints()) {
            return this.getMovementVector().m_82490_(1.0 / this.getMovementVector().m_82553_());
        }
        Pair<Vec3, Vec3> result = this.firstAndLast();
        Vec3 vec3 = result.getFirst().m_82546_(Vec3.f_82478_);
        return vec3.m_82490_(1.0 / vec3.m_82553_());
    }

    default public Vec3 endDirection() {
        if (!this.hasBezierPoints()) {
            return this.getMovementVector().m_82490_(1.0 / this.getMovementVector().m_82553_());
        }
        Pair<Vec3, Vec3> result = this.firstAndLast();
        Vec3 vec3 = this.getMovementVector().m_82546_(result.getSecond());
        return vec3.m_82490_(1.0 / vec3.m_82553_());
    }

    default public boolean removeBezierPoint(int index) {
        if (index < 0 || index > this.bezierPointCount()) {
            return false;
        }
        this.getBezierPoints().remove(index);
        return true;
    }

    default public boolean removeBezierPoint(Vec3 vec3) {
        return this.getBezierPoints().remove(vec3);
    }

    default public boolean containsPoint(Vec3 vec3) {
        return this.getBezierPoints().contains(vec3);
    }

    default public void clearBezierPoints() {
        this.getBezierPoints().clear();
    }
}

