/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.dom.registration;

import kasuga.lib.core.client.frontend.dom.DomContext;
import kasuga.lib.core.client.frontend.dom.registration.DOMPriorityRegistry;
import kasuga.lib.core.client.frontend.dom.registration.DOMRegistryItem;
import kasuga.lib.core.javascript.JavascriptContext;
import kasuga.lib.core.javascript.SideEffectContext;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;
import net.minecraft.resources.ResourceLocation;

public class DOMRegistryItemDynamicProxy {
    private final DomContext<?, ?> context;
    private final DOMPriorityRegistry registry;
    private final ResourceLocation id;
    private boolean closed = true;
    private JavascriptContext registryContext;
    private SideEffectContext sideEffectContext;

    public DOMRegistryItemDynamicProxy(DOMPriorityRegistry registry, ResourceLocation resourceLocation, DomContext context) {
        this.context = context;
        this.registry = registry;
        this.id = resourceLocation;
        this.sideEffectContext = new SideEffectContext();
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void load() {
        this.closed = false;
        Pair registryItemPair = this.registry.get(this.id);
        if (registryItemPair == null) {
            return;
        }
        DOMRegistryItem item = (DOMRegistryItem)registryItemPair.getFirst();
        JavascriptContext registryContext = registryItemPair.getSecond();
        registryContext.runTask(() -> {
            Value unload = item.render(this.context);
            if (unload.canExecute()) {
                this.sideEffectContext.collect(() -> unload.executeVoid(new Object[0]));
            }
        });
        this.registryContext = registryContext;
        registryContext.registerTickable(this.context);
        this.context.setReady();
    }

    public void unload() {
        this.closed = true;
        this.sideEffectContext.close();
        this.context.setNotReady();
    }

    public void enable() {
    }

    public void disable() {
    }

    public void notifyUpdate(ResourceLocation location) {
        if (this.id == location) {
            this.reload();
        }
    }
}

