/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.layout.yoga;

import java.util.ArrayList;
import java.util.Optional;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutCache;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.common.style.StyleList;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.layout.EdgeSize2D;
import kasuga.lib.core.client.frontend.gui.layout.yoga.MayMeasurable;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureFunction;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaNode;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomRoot;

public class YogaLayoutNode
implements LayoutNode {
    private final GuiDomNode domNode;
    private final YogaNode node;
    private final Object source;
    private final LayoutCache cache;
    protected YogaLayoutNode parent;
    protected ArrayList<YogaLayoutNode> children = new ArrayList();
    private EdgeSize2D padding = EdgeSize2D.ZERO;
    private EdgeSize2D margin = EdgeSize2D.ZERO;
    private EdgeSize2D border = EdgeSize2D.ZERO;

    public YogaLayoutNode(GuiDomNode node, Object source) {
        this.domNode = node;
        this.node = YogaNode.create();
        this.source = source;
        this.cache = new LayoutCache();
        this.regenerateMeasure();
    }

    @Override
    public boolean applyChanges() {
        StyleList<StyleTarget> styles = this.domNode.getStyle();
        if (!styles.hasNewStyle(this)) {
            return false;
        }
        styles.forEachCacheStyle(style -> ((StyleTarget)style.getTarget()).attemptApply(this.node));
        styles.resetNewStyle(this);
        return true;
    }

    @Override
    public boolean update() {
        if (this.node.hasNewLayout()) {
            this.node.visited();
            LayoutBox layout = LayoutBox.of(this.node.getLayoutLeft(), this.node.getLayoutTop(), this.node.getLayoutWidth(), this.node.getLayoutHeight());
            this.cache.setEngineCoordinate(layout);
            this.padding = EdgeSize2D.fromLambda(this.node::getLayoutPadding);
            this.margin = EdgeSize2D.fromLambda(this.node::getLayoutMargin);
            this.border = EdgeSize2D.fromLambda(this.node::getLayoutBorder);
            return true;
        }
        return false;
    }

    @Override
    public void calculate() {
        GuiDomNode guiDomNode = this.domNode;
        if (guiDomNode instanceof GuiDomRoot) {
            GuiDomRoot root = (GuiDomRoot)guiDomNode;
            LayoutBox size = ((GuiContext)root.getDomContext()).getSourceInfo((Object)this.source).size;
            this.node.calculateLayout(size.getWidth(), size.getHeight());
        }
    }

    @Override
    public LayoutBox getPosition() {
        return this.cache.screenCoordinate.get();
    }

    public EdgeSize2D getPadding() {
        return this.padding;
    }

    public EdgeSize2D getMargin() {
        return this.margin;
    }

    @Override
    public EdgeSize2D getBorder() {
        return this.border;
    }

    @Override
    public void markDirty() {
        this.cache.screenCoordinate.clear();
        this.regenerateMeasure();
        this.node.dirty();
    }

    protected void regenerateMeasure() {
        GuiDomNode guiDomNode = this.domNode;
        if (guiDomNode instanceof MayMeasurable) {
            MayMeasurable measurable = (MayMeasurable)((Object)guiDomNode);
            Optional<YogaMeasureFunction> measure = measurable.measure();
            if (measure.isPresent()) {
                this.node.setMeasureFunction(measure.get());
            } else {
                this.node.removeMeasureFunction();
            }
        }
    }

    @Override
    public void addChild(int index, LayoutNode node) {
        YogaLayoutNode yogaNode;
        if (node instanceof YogaLayoutNode) {
            yogaNode = (YogaLayoutNode)node;
            if (yogaNode.parent != null) {
                return;
            }
        } else {
            throw new IllegalStateException();
        }
        this.node.addChildAt(index, yogaNode.node);
        this.children.add(index, yogaNode);
        yogaNode.cache.setTracking(this.cache);
        yogaNode.parent = this;
    }

    @Override
    public void removeChild(int index) {
        this.node.removeChildAt(index);
        this.children.remove(index);
    }

    @Override
    public void removeChild(LayoutNode node) {
        if (!(node instanceof YogaLayoutNode)) {
            throw new IllegalStateException();
        }
        YogaLayoutNode yogaNode = (YogaLayoutNode)node;
        this.node.removeChild(yogaNode.node);
        yogaNode.cache.setTracking(null);
        yogaNode.parent = null;
    }

    @Override
    public void close() {
        for (YogaLayoutNode child : this.children) {
            child.close();
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.node.close();
    }

    @Override
    public LayoutBox getRelative() {
        return this.cache.engineCoordinate;
    }
}

