/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.nodes;

import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutContext;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.common.style.StyleAttributeProxy;
import kasuga.lib.core.client.frontend.common.style.StyleList;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.dom.nodes.DomNode;
import kasuga.lib.core.client.frontend.font.ExtendableProperty;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.events.MouseEvent;
import kasuga.lib.core.client.frontend.gui.layout.EdgeSize2D;
import kasuga.lib.core.client.frontend.rendering.BackgroundRenderer;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.HostAccess;
import kasuga.lib.vendor_modules.org.graalvm.polyglot.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.common.util.Lazy;

public class GuiDomNode
extends DomNode<GuiContext> {
    @HostAccess.Export
    public StyleList<StyleTarget> styles;
    public ExtendableProperty<Integer> fontSize;
    Lazy<LayoutContext<?, GuiDomNode>> layoutManager;
    protected BackgroundRenderer background;

    protected void fontSizeUpdated() {
    }

    GuiDomNode(GuiContext context) {
        super(context);
        this.styles = new StyleList<StyleTarget>(KasugaLib.STACKS.GUI.orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/IllegalStateException;)()).styleRegistry);
        this.fontSize = new ExtendableProperty<Integer>(() -> {
            Integer n;
            DomNode patt1510$temp = this.parent;
            if (patt1510$temp instanceof GuiDomNode) {
                GuiDomNode node = (GuiDomNode)patt1510$temp;
                n = node.fontSize.get();
            } else {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                n = 9;
            }
            return n;
        }, () -> {
            this.children.forEach(c -> {
                if (c instanceof GuiDomNode) {
                    GuiDomNode child = (GuiDomNode)c;
                    child.fontSize.notifyUpdate();
                }
            });
            this.fontSizeUpdated();
        });
        this.layoutManager = Lazy.concurrentOf(() -> new LayoutContext(this, ((GuiContext)this.domContext).getLayoutEngine()));
        this.background = new BackgroundRenderer();
        this.attributes.registerProxy("style", new StyleAttributeProxy(this.styles));
        this.styles.setCallback(this::onStyleUpdate);
    }

    private void onStyleUpdate() {
        DomNode domNode;
        if (this.parent != null && (domNode = this.parent) instanceof GuiDomNode) {
            GuiDomNode parentNode = (GuiDomNode)domNode;
            parentNode.styles.notifyUpdate();
        }
    }

    public StyleList<StyleTarget> getStyle() {
        return this.styles;
    }

    public LayoutContext<?, GuiDomNode> getLayoutManager() {
        return (LayoutContext)this.layoutManager.get();
    }

    @Override
    @HostAccess.Export
    public boolean addChildAt(int i, DomNode<GuiContext> child) {
        if (child instanceof GuiDomNode) {
            GuiDomNode domNode = (GuiDomNode)child;
            this.getLayoutManager().addChild(i, domNode.getLayoutManager());
        }
        this.styles.notifyUpdate();
        return super.addChildAt(i, child);
    }

    @Override
    @HostAccess.Export
    public boolean removeChild(DomNode<GuiContext> child) {
        boolean result = super.removeChild(child);
        if (child instanceof GuiDomNode) {
            GuiDomNode domNode = (GuiDomNode)child;
            this.getLayoutManager().removeChild(domNode.getLayoutManager());
        }
        this.styles.notifyUpdate();
        return result;
    }

    @Override
    public void render(Object source, RenderContext context) {
        this.updateStyles();
        LayoutNode layout = this.getLayoutManager().getSourceNode(source);
        LayoutBox coordinate = layout.getPosition();
        this.background.render(context, (int)coordinate.x, (int)coordinate.y, (int)coordinate.width, (int)coordinate.height);
        EdgeSize2D border = layout.getBorder();
        MultiBufferSource bufferSource = context.getBufferSource();
        super.render(source, context);
    }

    private void updateStyles() {
        if (!this.styles.hasNewStyle(this)) {
            return;
        }
        this.styles.forEachCacheStyle(style -> ((StyleTarget)style.getTarget()).attemptApply(this));
        this.styles.resetNewStyle(this);
    }

    @Override
    public void close() {
        super.close();
        this.getLayoutManager().close();
    }

    @Override
    @HostAccess.Export
    public boolean hasFeature(String feature) {
        if (Objects.equals(feature, "style")) {
            return true;
        }
        return super.hasFeature(feature);
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.background;
    }

    public boolean onMouseEvent(Object source, MouseEvent event) {
        LayoutContext<?, GuiDomNode> layout = this.getLayoutManager();
        LayoutNode sourceNode = layout.getSourceNode(source);
        if (sourceNode == null) {
            return false;
        }
        LayoutBox box = sourceNode.getRelative();
        if (!box.contains(event.getOffsetPosition().x, event.getOffsetPosition().y)) {
            return false;
        }
        LayoutBox screen = sourceNode.getPosition();
        MouseEvent translated = event.forkChild(this, event.getScreenPosition().x - (int)screen.x, event.getScreenPosition().y - (int)screen.y);
        GuiDomNode target = this;
        for (DomNode child : this.children) {
            GuiDomNode domNode;
            if (!(child instanceof GuiDomNode) || !(domNode = (GuiDomNode)child).onMouseEvent(source, translated)) continue;
            target = domNode;
            break;
        }
        MouseEvent finalEvent = event.withTarget(target);
        if (!translated.isPropagationStopped()) {
            this.dispatchEvent(event.getType(), Value.asValue(finalEvent));
        } else {
            event.stopPropagation();
        }
        return true;
    }
}

