/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.node;

import java.util.Map;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.styles.node.SimpleNodeStyleType;

public class FontSizeStyle
extends Style<Float, StyleTarget> {
    public static final StyleType<FontSizeStyle, StyleTarget> TYPE = SimpleNodeStyleType.of(FontSizeStyle::new, "0");
    float value;
    boolean valid;

    public FontSizeStyle(String size) {
        try {
            this.value = Float.parseFloat(size);
            this.valid = true;
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.valid;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return TYPE;
    }

    @Override
    public StyleTarget getTarget() {
        return StyleTarget.GUI_DOM_NODE.create(node -> node.fontSize.setSize((int)this.value));
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }
}

