/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.model.anim_json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.model.anim_json.Animation;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.Resources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimationFile {
    public final String formatVersion;
    public final ResourceLocation location;
    private final JsonObject animationsJson;
    private final HashMap<String, Animation> animations;
    public static final HashMap<ResourceLocation, AnimationFile> FILES = new HashMap();
    public static final HashSet<ResourceLocation> UNREGISTERED = new HashSet();
    public static boolean filesLoaded = false;

    public AnimationFile(ResourceLocation location, JsonObject json) {
        this.location = location;
        this.formatVersion = json.get("format_version").getAsString();
        this.animations = new HashMap();
        if (!json.has("animations")) {
            this.animationsJson = new JsonObject();
            return;
        }
        this.animationsJson = json.getAsJsonObject("animations");
        this.parseAnim();
    }

    private void parseAnim() {
        this.animationsJson.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                Animation animation = new Animation(name, object, this);
                this.animations.put(name, animation);
            }
        });
    }

    public Animation getAnimation(String name) {
        return this.animations.getOrDefault(name, null);
    }

    public boolean hasAnimation(String name) {
        return this.animations.containsKey(name);
    }

    public static LazyRecomputable<AnimationFile> fromFile(ResourceLocation location) {
        ResourceLocation location1 = new ResourceLocation(location.m_135827_(), "animations/" + location.m_135815_() + ".animation.json");
        if (!filesLoaded) {
            UNREGISTERED.add(location);
            return LazyRecomputable.of(() -> FILES.getOrDefault(location, null));
        }
        if (FILES.containsKey(location)) {
            return LazyRecomputable.of(() -> FILES.get(location));
        }
        try {
            Resource resource = Resources.getResource(location1);
            JsonObject object = JsonParser.parseReader((Reader)resource.m_215508_()).getAsJsonObject();
            AnimationFile file = new AnimationFile(location1, object);
            FILES.put(location, file);
            return LazyRecomputable.of(() -> file);
        }
        catch (IOException e) {
            KasugaLib.MAIN_LOGGER.error("Failed to open animation file " + location1, (Throwable)e);
            return LazyRecomputable.of(() -> null);
        }
    }
}

